/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.Distance;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.Context;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.Pipeline;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderBin;
import javax.media.j3d.Renderer;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Point4f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

abstract class GeometryArrayRetained
extends GeometryRetained {
    int vertexFormat;
    int c4fAllocated = 0;
    int vertexCount;
    int validVertexCount;
    float[] vertexData;
    private float[][] mvertexData;
    int stride;
    int texCoordStride;
    int coordinateOffset;
    int normalOffset;
    int colorOffset;
    int textureOffset;
    int[] vertexAttrOffsets;
    int vertexAttrStride;
    private float[] lastAlpha = new float[1];
    float lastScreenAlpha = -1.0f;
    int colorChanged = 0;
    static final float ByteToFloatScale = 0.003921569f;
    static final float FloatToByteScale = 255.0f;
    boolean inUpdater = false;
    ArrayList gaList = new ArrayList(1);
    static final int targetThreads = 192;
    float[] floatRefCoords = null;
    double[] doubleRefCoords = null;
    Point3d[] p3dRefCoords = null;
    Point3f[] p3fRefCoords = null;
    J3DBuffer coordRefBuffer = null;
    FloatBufferWrapper floatBufferRefCoords = null;
    DoubleBufferWrapper doubleBufferRefCoords = null;
    int initialCoordIndex = 0;
    int initialColorIndex = 0;
    int initialNormalIndex = 0;
    int[] initialTexCoordIndex = null;
    int[] initialVertexAttrIndex = null;
    int initialVertexIndex = 0;
    float[] floatRefColors = null;
    byte[] byteRefColors = null;
    Color3f[] c3fRefColors = null;
    Color4f[] c4fRefColors = null;
    Color3b[] c3bRefColors = null;
    Color4b[] c4bRefColors = null;
    J3DBuffer colorRefBuffer = null;
    FloatBufferWrapper floatBufferRefColors = null;
    ByteBufferWrapper byteBufferRefColors = null;
    int vertexType = 0;
    static final int PF = 1;
    static final int PD = 2;
    static final int P3F = 4;
    static final int P3D = 8;
    static final int VERTEX_DEFINED = 15;
    static final int CF = 16;
    static final int CUB = 32;
    static final int C3F = 64;
    static final int C4F = 128;
    static final int C3UB = 256;
    static final int C4UB = 512;
    static final int COLOR_DEFINED = 1008;
    static final int NF = 1024;
    static final int N3F = 2048;
    static final int NORMAL_DEFINED = 3072;
    static final int TF = 4096;
    static final int T2F = 8192;
    static final int T3F = 16384;
    static final int TEXCOORD_DEFINED = 28672;
    static final int AF = 32768;
    static final int VATTR_DEFINED = 32768;
    private int texCoordType = 0;
    private int vertexAttrType = 0;
    static final int COORD_FLOAT = 1;
    static final int COORD_DOUBLE = 2;
    static final int COLOR_FLOAT = 4;
    static final int COLOR_BYTE = 8;
    static final int NORMAL_FLOAT = 16;
    static final int TEXCOORD_FLOAT = 32;
    static final int VATTR_FLOAT = 64;
    float[] floatRefNormals = null;
    Vector3f[] v3fRefNormals = null;
    J3DBuffer normalRefBuffer = null;
    FloatBufferWrapper floatBufferRefNormals = null;
    float[][] floatRefVertexAttrs = null;
    J3DBuffer[] vertexAttrsRefBuffer = null;
    FloatBufferWrapper[] floatBufferRefVertexAttrs = null;
    Object[] nioFloatBufferRefVertexAttrs = null;
    Object[] refTexCoords = null;
    TexCoord2f[] t2fRefTexCoords = null;
    TexCoord3f[] t3fRefTexCoords = null;
    Object[] refTexCoordsBuffer = null;
    float[] interLeavedVertexData = null;
    J3DBuffer interleavedVertexBuffer = null;
    FloatBufferWrapper interleavedFloatBufferImpl = null;
    float[] mirrorFloatRefCoords = null;
    double[] mirrorDoubleRefCoords = null;
    float[] mirrorFloatRefNormals = null;
    float[][] mirrorFloatRefVertexAttrs = null;
    float[] mirrorFloatRefTexCoords = null;
    Object[] mirrorRefTexCoords = null;
    float[][] mirrorFloatRefColors = new float[1][];
    byte[][] mirrorUnsignedByteRefColors = new byte[1][];
    float[][] mirrorInterleavedColorPointer = null;
    int mirrorVertexAllocated = 0;
    int mirrorColorAllocated = 0;
    boolean mirrorNormalAllocated = false;
    static final int COORDINATE_CHANGED = 1;
    static final int NORMAL_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int TEXTURE_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int INDEX_CHANGED = 32;
    static final int STRIPCOUNT_CHANGED = 64;
    static final int VATTR_CHANGED = 128;
    static final int VERTEX_CHANGED = 143;
    static final int[] defaultTexCoordSetMap = new int[]{0};
    int texCoordSetCount = 0;
    int[] texCoordSetMap = null;
    int[] texCoordSetMapOffset = null;
    int vertexAttrCount = 0;
    int[] vertexAttrSizes = null;
    long pVertexBuffers = 0L;
    int dirtyFlag = 175;
    int resourceCreationMask = 0;
    private HashMap dlistUsers = null;
    private long[] timeStampPerDlist = new long[2];
    int dlistId = -1;
    Integer dlistObj = null;
    static final int INIT_MIRROR_GEOMETRY = 2;
    ArrayList morphUniverseList = null;
    ArrayList morphUserLists = null;
    int[] geoOffset;
    int[] compileVcount;
    boolean isCompiled = false;
    boolean isShared = false;
    IndexedGeometryArrayRetained cloneSourceArray = null;
    static final double EPS = 1.0E-13;

    void freeD3DArray(boolean bl) {
        assert (VirtualUniverse.mc.isD3D());
        Pipeline.getPipeline().freeD3DArray(this, bl);
    }

    GeometryArrayRetained() {
        this.lastAlpha[0] = 1.0f;
    }

    void setLive(boolean bl, int n2) {
        this.dirtyFlag = 175;
        this.isEditable = !this.isWriteStatic();
        super.doSetLive(bl, n2);
        super.markAsLive();
        if (this.refCount > 1) {
            this.isShared = true;
        } else if (this instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 1024;
            j3dMessage.type = 17;
            j3dMessage.universe = null;
            j3dMessage.args[0] = null;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = new Integer(2);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void clearLive(int n2) {
        super.clearLive(n2);
        if (this.refCount <= 0) {
            if (this.pVertexBuffers != 0L) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 44;
                j3dMessage.universe = null;
                j3dMessage.view = null;
                j3dMessage.args[0] = null;
                j3dMessage.args[1] = this;
                Enumeration enumeration = Screen3D.deviceRendererMap.elements();
                Renderer renderer = (Renderer)enumeration.nextElement();
                renderer.rendererStructure.addMessage(j3dMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
            this.isShared = false;
        }
    }

    void computeBoundingBox() {
        if (this.boundsDirty && VirtualUniverse.mc.cacheAutoComputedBounds) {
            for (ArrayList arrayList : this.userLists) {
                for (Shape3DRetained shape3DRetained : arrayList) {
                    shape3DRetained.dirtyBoundsCache();
                }
            }
        }
        if ((this.vertexFormat & 0x80) == 0) {
            this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        } else if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                this.computeBoundingBox(this.initialCoordIndex, this.interleavedFloatBufferImpl);
            } else if ((this.vertexType & 1) != 0) {
                this.computeBoundingBox(this.floatBufferRefCoords);
            } else if ((this.vertexType & 2) != 0) {
                this.computeBoundingBox(this.doubleBufferRefCoords);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
        } else if ((this.vertexType & 1) != 0) {
            this.computeBoundingBox(this.floatRefCoords);
        } else if ((this.vertexType & 4) != 0) {
            this.computeBoundingBox(this.p3fRefCoords);
        } else if ((this.vertexType & 8) != 0) {
            this.computeBoundingBox(this.p3dRefCoords);
        } else if ((this.vertexType & 2) != 0) {
            this.computeBoundingBox(this.doubleRefCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCoordsChanged(boolean bl) {
        if (bl) {
            Cloneable cloneable = this.geoBounds;
            synchronized (cloneable) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
                this.boundsDirty = false;
            }
            cloneable = this.centroid;
            synchronized (cloneable) {
                this.recompCentroid = false;
                this.centroid.set(this.geoBounds.getCenter());
            }
        }
        Cloneable cloneable = this.centroid;
        synchronized (cloneable) {
            this.recompCentroid = true;
        }
        cloneable = this.geoBounds;
        synchronized (cloneable) {
            this.boundsDirty = true;
            this.computeBoundingBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n2, float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n3 = n2 * this.stride + this.coordinateOffset;
            double d5 = d4 = (double)fArray[n3];
            double d6 = d3 = (double)fArray[n3 + 1];
            double d7 = d2 = (double)fArray[n3 + 2];
            n3 += this.stride;
            for (int i2 = 1; i2 < this.validVertexCount; ++i2) {
                if ((double)fArray[n3] > d4) {
                    d4 = fArray[n3];
                }
                if ((double)fArray[n3] < d5) {
                    d5 = fArray[n3];
                }
                if ((double)fArray[n3 + 1] > d3) {
                    d3 = fArray[n3 + 1];
                }
                if ((double)fArray[n3 + 1] < d6) {
                    d6 = fArray[n3 + 1];
                }
                if ((double)fArray[n3 + 2] > d2) {
                    d2 = fArray[n3 + 2];
                }
                if ((double)fArray[n3 + 2] < d7) {
                    d7 = fArray[n3 + 2];
                }
                n3 += this.stride;
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n2, FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n3 = n2 * this.stride + this.coordinateOffset;
            double d5 = d4 = (double)floatBufferWrapper.get(n3);
            double d6 = d3 = (double)floatBufferWrapper.get(n3 + 1);
            double d7 = d2 = (double)floatBufferWrapper.get(n3 + 2);
            n3 += this.stride;
            for (int i2 = 1; i2 < this.validVertexCount; ++i2) {
                if ((double)floatBufferWrapper.get(n3) > d4) {
                    d4 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n3) < d5) {
                    d5 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n3 + 1) > d3) {
                    d3 = floatBufferWrapper.get(n3 + 1);
                }
                if ((double)floatBufferWrapper.get(n3 + 1) < d6) {
                    d6 = floatBufferWrapper.get(n3 + 1);
                }
                if ((double)floatBufferWrapper.get(n3 + 2) > d2) {
                    d2 = floatBufferWrapper.get(n3 + 2);
                }
                if ((double)floatBufferWrapper.get(n3 + 2) < d7) {
                    d7 = floatBufferWrapper.get(n3 + 2);
                }
                n3 += this.stride;
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(DoubleBufferWrapper doubleBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = this.initialCoordIndex;
            int n3 = 3 * this.validVertexCount;
            double d5 = d4 = doubleBufferWrapper.get(n2++);
            double d6 = d3 = doubleBufferWrapper.get(n2++);
            double d7 = d2 = doubleBufferWrapper.get(n2++);
            for (int i2 = n2; i2 < n3; i2 += 3) {
                int n4 = i2 + 1;
                int n5 = i2 + 2;
                if (doubleBufferWrapper.get(i2) > d4) {
                    d4 = doubleBufferWrapper.get(i2);
                }
                if (doubleBufferWrapper.get(i2) < d5) {
                    d5 = doubleBufferWrapper.get(i2);
                }
                if (doubleBufferWrapper.get(n4) > d3) {
                    d3 = doubleBufferWrapper.get(n4);
                }
                if (doubleBufferWrapper.get(n4) < d6) {
                    d6 = doubleBufferWrapper.get(n4);
                }
                if (doubleBufferWrapper.get(n5) > d2) {
                    d2 = doubleBufferWrapper.get(n5);
                }
                if (!(doubleBufferWrapper.get(n5) < d7)) continue;
                d7 = doubleBufferWrapper.get(n5);
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = this.initialCoordIndex;
            int n3 = 3 * this.validVertexCount;
            double d5 = d4 = (double)floatBufferWrapper.get(n2++);
            double d6 = d3 = (double)floatBufferWrapper.get(n2++);
            double d7 = d2 = (double)floatBufferWrapper.get(n2++);
            for (int i2 = n2; i2 < n3; i2 += 3) {
                int n4 = i2 + 1;
                int n5 = i2 + 2;
                if ((double)floatBufferWrapper.get(i2) > d4) {
                    d4 = floatBufferWrapper.get(i2);
                }
                if ((double)floatBufferWrapper.get(i2) < d5) {
                    d5 = floatBufferWrapper.get(i2);
                }
                if ((double)floatBufferWrapper.get(n4) > d3) {
                    d3 = floatBufferWrapper.get(n4);
                }
                if ((double)floatBufferWrapper.get(n4) < d6) {
                    d6 = floatBufferWrapper.get(n4);
                }
                if ((double)floatBufferWrapper.get(n5) > d2) {
                    d2 = floatBufferWrapper.get(n5);
                }
                if (!((double)floatBufferWrapper.get(n5) < d7)) continue;
                d7 = floatBufferWrapper.get(n5);
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = this.initialCoordIndex;
            int n3 = 3 * this.validVertexCount;
            double d5 = d4 = (double)fArray[n2++];
            double d6 = d3 = (double)fArray[n2++];
            double d7 = d2 = (double)fArray[n2++];
            for (int i2 = n2; i2 < n3; i2 += 3) {
                int n4 = i2 + 1;
                int n5 = i2 + 2;
                if ((double)fArray[i2] > d4) {
                    d4 = fArray[i2];
                }
                if ((double)fArray[i2] < d5) {
                    d5 = fArray[i2];
                }
                if ((double)fArray[n4] > d3) {
                    d3 = fArray[n4];
                }
                if ((double)fArray[n4] < d6) {
                    d6 = fArray[n4];
                }
                if ((double)fArray[n5] > d2) {
                    d2 = fArray[n5];
                }
                if (!((double)fArray[n5] < d7)) continue;
                d7 = fArray[n5];
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(double[] dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = this.initialCoordIndex;
            int n3 = 3 * this.validVertexCount;
            double d5 = d4 = dArray[n2++];
            double d6 = d3 = dArray[n2++];
            double d7 = d2 = dArray[n2++];
            for (int i2 = n2; i2 < n3; i2 += 3) {
                int n4 = i2 + 1;
                int n5 = i2 + 2;
                if (dArray[i2] > d4) {
                    d4 = dArray[i2];
                }
                if (dArray[i2] < d5) {
                    d5 = dArray[i2];
                }
                if (dArray[n4] > d3) {
                    d3 = dArray[n4];
                }
                if (dArray[n4] < d6) {
                    d6 = dArray[n4];
                }
                if (dArray[n5] > d2) {
                    d2 = dArray[n5];
                }
                if (!(dArray[n5] < d7)) continue;
                d7 = dArray[n5];
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3f[] point3fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d5 = d4 = (double)point3fArray[this.initialCoordIndex].x;
            double d6 = d3 = (double)point3fArray[this.initialCoordIndex].y;
            double d7 = d2 = (double)point3fArray[this.initialCoordIndex].z;
            for (int i2 = this.initialCoordIndex + 1; i2 < this.validVertexCount; ++i2) {
                Point3f point3f = point3fArray[i2];
                if ((double)point3f.x > d4) {
                    d4 = point3f.x;
                }
                if ((double)point3f.x < d5) {
                    d5 = point3f.x;
                }
                if ((double)point3f.y > d3) {
                    d3 = point3f.y;
                }
                if ((double)point3f.y < d6) {
                    d6 = point3f.y;
                }
                if ((double)point3f.z > d2) {
                    d2 = point3f.z;
                }
                if (!((double)point3f.z < d7)) continue;
                d7 = point3f.z;
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3d[] point3dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d2;
            double d3;
            double d4;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d5 = d4 = point3dArray[this.initialCoordIndex].x;
            double d6 = d3 = point3dArray[this.initialCoordIndex].y;
            double d7 = d2 = point3dArray[this.initialCoordIndex].z;
            for (int i2 = this.initialCoordIndex + 1; i2 < this.validVertexCount; ++i2) {
                Point3d point3d = point3dArray[i2];
                if (point3d.x > d4) {
                    d4 = point3d.x;
                }
                if (point3d.x < d5) {
                    d5 = point3d.x;
                }
                if (point3d.y > d3) {
                    d3 = point3d.y;
                }
                if (point3d.y < d6) {
                    d6 = point3d.y;
                }
                if (point3d.z > d2) {
                    d2 = point3d.z;
                }
                if (!(point3d.z < d7)) continue;
                d7 = point3d.z;
            }
            this.geoBounds.setUpper(d4, d3, d2);
            this.geoBounds.setLower(d5, d6, d7);
            this.boundsDirty = false;
        }
    }

    synchronized void update() {
    }

    void setupMirrorVertexPointer(int n2) {
        switch (n2) {
            case 1: {
                if (this.floatRefCoords == null) {
                    if ((this.vertexType & 0xF) != 1) break;
                    this.vertexType &= 0xFFFFFFFE;
                    this.mirrorFloatRefCoords = null;
                    this.mirrorVertexAllocated &= 0xFFFFFFFE;
                    break;
                }
                this.vertexType |= 1;
                this.mirrorFloatRefCoords = this.floatRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFE;
                break;
            }
            case 2: {
                if (this.doubleRefCoords == null) {
                    if ((this.vertexType & 0xF) == 2) {
                        this.mirrorDoubleRefCoords = null;
                        this.mirrorVertexAllocated &= 0xFFFFFFFD;
                        this.vertexType &= 0xFFFFFFFD;
                    }
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                this.vertexType |= 2;
                this.mirrorDoubleRefCoords = this.doubleRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFD;
                break;
            }
            case 4: {
                if (this.p3fRefCoords == null) {
                    this.vertexType &= 0xFFFFFFFB;
                    break;
                }
                this.vertexType |= 4;
                if ((this.mirrorVertexAllocated & 1) == 0) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 1;
                }
                int n3 = this.initialCoordIndex * 3;
                for (int i2 = this.initialCoordIndex; i2 < this.validVertexCount; ++i2) {
                    this.mirrorFloatRefCoords[n3++] = this.p3fRefCoords[i2].x;
                    this.mirrorFloatRefCoords[n3++] = this.p3fRefCoords[i2].y;
                    this.mirrorFloatRefCoords[n3++] = this.p3fRefCoords[i2].z;
                }
                break;
            }
            case 8: {
                if (this.p3dRefCoords == null) {
                    this.vertexType &= 0xFFFFFFF7;
                    break;
                }
                this.vertexType |= 8;
                if ((this.mirrorVertexAllocated & 2) == 0) {
                    this.mirrorDoubleRefCoords = new double[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 2;
                }
                int n4 = this.initialCoordIndex * 3;
                for (int i3 = this.initialCoordIndex; i3 < this.validVertexCount; ++i3) {
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[i3].x;
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[i3].y;
                    this.mirrorDoubleRefCoords[n4++] = this.p3dRefCoords[i3].z;
                }
                break;
            }
        }
    }

    void setupMirrorInterleavedColorPointer(boolean bl) {
        if (bl || this.c4fAllocated != 0) {
            int n2 = 4 * this.vertexCount;
            if (this.mirrorInterleavedColorPointer == null) {
                this.mirrorInterleavedColorPointer = new float[1][n2];
            }
            int n3 = 4 * this.initialVertexIndex;
            int n4 = this.stride * this.initialVertexIndex + this.colorOffset;
            if ((this.vertexFormat & 0x800) == 0 && this.interLeavedVertexData != null) {
                if ((this.vertexFormat & 8) != 0) {
                    for (int i2 = this.initialVertexIndex; i2 < this.validVertexCount; ++i2) {
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4];
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4 + 1];
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4 + 2];
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4 + 3];
                        n4 += this.stride;
                    }
                } else {
                    for (int i3 = this.initialVertexIndex; i3 < this.validVertexCount; ++i3) {
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4];
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4 + 1];
                        this.mirrorInterleavedColorPointer[0][n3++] = this.interLeavedVertexData[n4 + 2];
                        this.mirrorInterleavedColorPointer[0][n3++] = 1.0f;
                        n4 += this.stride;
                    }
                }
            } else if ((this.vertexFormat & 8) != 0 && this.interleavedFloatBufferImpl != null) {
                for (int i4 = this.initialVertexIndex; i4 < this.validVertexCount; ++i4) {
                    this.interleavedFloatBufferImpl.position(n4);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n3, 4);
                    n3 += 4;
                    n4 += this.stride;
                }
            } else {
                for (int i5 = this.initialVertexIndex; i5 < this.validVertexCount; ++i5) {
                    this.interleavedFloatBufferImpl.position(n4);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n3, 3);
                    this.mirrorInterleavedColorPointer[0][n3 + 3] = 1.0f;
                    n3 += 4;
                    n4 += this.stride;
                }
            }
            this.c4fAllocated = 8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setupMirrorColorPointer(int n2, boolean bl) {
        block61: {
            int n3;
            int n4;
            block63: {
                block62: {
                    int n5;
                    n4 = 0;
                    n3 = 0;
                    if (this.c4fAllocated == 0 && !bl) {
                        n5 = 3;
                    } else {
                        if (bl && this.c4fAllocated == 0 && (this.vertexFormat & 8) == 0) {
                            this.mirrorColorAllocated = 0;
                        }
                        this.c4fAllocated = 8;
                        n5 = 4;
                    }
                    if ((this.vertexFormat & 0x800) != 0) break block62;
                    switch (n2) {
                        case 16: {
                            if (this.floatRefColors == null) {
                                if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 16) {
                                    this.mirrorFloatRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                                }
                                this.vertexType &= 0xFFFFFFEF;
                                return;
                            }
                            this.vertexType |= 0x10;
                            if (this.c4fAllocated == 0 && !bl) {
                                this.mirrorFloatRefColors[0] = this.floatRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFEF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                n4 = this.initialColorIndex * 3;
                                n3 = this.initialColorIndex * 4;
                                for (int i2 = this.initialColorIndex; i2 < this.validVertexCount; ++i2) {
                                    this.mirrorFloatRefColors[0][n3++] = this.floatRefColors[n4++];
                                    this.mirrorFloatRefColors[0][n3++] = this.floatRefColors[n4++];
                                    this.mirrorFloatRefColors[0][n3++] = this.floatRefColors[n4++];
                                    this.mirrorFloatRefColors[0][n3++] = 1.0f;
                                }
                                break block61;
                            } else {
                                n4 = this.initialColorIndex * 4;
                                System.arraycopy(this.floatRefColors, n4, this.mirrorFloatRefColors[0], n4, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 32: {
                            if (this.byteRefColors == null) {
                                if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 32) {
                                    this.mirrorUnsignedByteRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                                }
                                this.vertexType &= 0xFFFFFFDF;
                                return;
                            }
                            this.vertexType |= 0x20;
                            if (this.c4fAllocated == 0 && !bl) {
                                this.mirrorUnsignedByteRefColors[0] = this.byteRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFDF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                n4 = this.initialColorIndex * 3;
                                n3 = this.initialColorIndex * 4;
                                for (int i3 = this.initialColorIndex; i3 < this.validVertexCount; ++i3) {
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.byteRefColors[n4++];
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.byteRefColors[n4++];
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.byteRefColors[n4++];
                                    this.mirrorUnsignedByteRefColors[0][n3++] = -1;
                                }
                                break block61;
                            } else {
                                n4 = this.initialColorIndex * 4;
                                System.arraycopy(this.byteRefColors, n4, this.mirrorUnsignedByteRefColors[0], n4, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 64: {
                            if (this.c3fRefColors == null) {
                                this.vertexType &= 0xFFFFFFBF;
                                return;
                            }
                            this.vertexType |= 0x40;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount * n5];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                n3 = this.initialColorIndex * 3;
                                for (int i4 = this.initialColorIndex; i4 < this.validVertexCount; ++i4) {
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i4].x;
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i4].y;
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i4].z;
                                }
                                break block61;
                            } else {
                                n3 = this.initialColorIndex * 4;
                                for (int i5 = this.initialColorIndex; i5 < this.validVertexCount; ++i5) {
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i5].x;
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i5].y;
                                    this.mirrorFloatRefColors[0][n3++] = this.c3fRefColors[i5].z;
                                    this.mirrorFloatRefColors[0][n3++] = 1.0f;
                                }
                            }
                            break block61;
                        }
                        case 128: {
                            if (this.c4fRefColors == null) {
                                this.vertexType &= 0xFFFFFF7F;
                                return;
                            }
                            this.vertexType |= 0x80;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            n3 = this.initialColorIndex * 4;
                            for (int i6 = this.initialColorIndex; i6 < this.validVertexCount; ++i6) {
                                this.mirrorFloatRefColors[0][n3++] = this.c4fRefColors[i6].x;
                                this.mirrorFloatRefColors[0][n3++] = this.c4fRefColors[i6].y;
                                this.mirrorFloatRefColors[0][n3++] = this.c4fRefColors[i6].z;
                                this.mirrorFloatRefColors[0][n3++] = this.c4fRefColors[i6].w;
                            }
                            break;
                        }
                        case 256: {
                            if (this.c3bRefColors == null) {
                                this.vertexType &= 0xFFFFFEFF;
                                return;
                            }
                            this.vertexType |= 0x100;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount * n5];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                n3 = this.initialColorIndex * 3;
                                for (int i7 = this.initialColorIndex; i7 < this.validVertexCount; ++i7) {
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i7].x;
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i7].y;
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i7].z;
                                }
                                break block61;
                            } else {
                                n3 = this.initialColorIndex * 4;
                                for (int i8 = this.initialColorIndex; i8 < this.validVertexCount; ++i8) {
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i8].x;
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i8].y;
                                    this.mirrorUnsignedByteRefColors[0][n3++] = this.c3bRefColors[i8].z;
                                    this.mirrorUnsignedByteRefColors[0][n3++] = -1;
                                }
                            }
                            break block61;
                        }
                        case 512: {
                            if (this.c4bRefColors == null) {
                                this.vertexType &= 0xFFFFFDFF;
                                return;
                            }
                            this.vertexType |= 0x200;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            n3 = this.initialColorIndex * 4;
                            for (int i9 = this.initialColorIndex; i9 < this.validVertexCount; ++i9) {
                                this.mirrorUnsignedByteRefColors[0][n3++] = this.c4bRefColors[i9].x;
                                this.mirrorUnsignedByteRefColors[0][n3++] = this.c4bRefColors[i9].y;
                                this.mirrorUnsignedByteRefColors[0][n3++] = this.c4bRefColors[i9].z;
                                this.mirrorUnsignedByteRefColors[0][n3++] = this.c4bRefColors[i9].w;
                            }
                            break;
                        }
                    }
                    break block61;
                }
                if (this.colorRefBuffer == null) {
                    if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 16) {
                        this.mirrorFloatRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFEF;
                    }
                    this.vertexType &= 0xFFFFFFEF;
                    if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 32) {
                        this.mirrorUnsignedByteRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFDF;
                    }
                    this.vertexType &= 0xFFFFFFDF;
                    return;
                }
                if (this.floatBufferRefColors == null) break block63;
                this.vertexType |= 0x10;
                this.vertexType &= 0xFFFFFFDF;
                if (this.c4fAllocated == 0 && !bl) {
                    this.mirrorFloatRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                    break block61;
                } else {
                    if ((this.mirrorColorAllocated & 0x10) == 0) {
                        this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x10;
                    }
                    this.floatBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        n4 = this.initialColorIndex * 3;
                        n3 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(n4);
                        for (int i10 = this.initialColorIndex; i10 < this.validVertexCount; n3 += 4, ++i10) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], n3, 3);
                            this.mirrorFloatRefColors[0][n3 + 3] = 1.0f;
                        }
                        break block61;
                    } else {
                        n4 = this.initialColorIndex * 4;
                        n3 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(n4);
                        for (int i11 = this.initialColorIndex; i11 < this.validVertexCount; n3 += 4, ++i11) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], n3, 4);
                        }
                    }
                }
                break block61;
            }
            if (this.byteBufferRefColors != null) {
                this.vertexType |= 0x20;
                this.vertexType &= 0xFFFFFFEF;
                if (this.c4fAllocated == 0 && !bl) {
                    this.mirrorUnsignedByteRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                } else {
                    if ((this.mirrorColorAllocated & 0x20) == 0) {
                        this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x20;
                    }
                    this.byteBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        n4 = this.initialColorIndex * 3;
                        n3 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(n4);
                        for (int i12 = this.initialColorIndex; i12 < this.validVertexCount; n3 += 4, ++i12) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], n3, 3);
                            this.mirrorUnsignedByteRefColors[0][n3 + 3] = -1;
                        }
                    } else {
                        n4 = this.initialColorIndex * 4;
                        n3 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(n4);
                        for (int i13 = this.initialColorIndex; i13 < this.validVertexCount; n3 += 4, ++i13) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], n3, 4);
                        }
                    }
                }
            }
        }
        this.colorChanged = 65535;
    }

    void setupMirrorNormalPointer(int n2) {
        switch (n2) {
            case 1024: {
                if (this.floatRefNormals == null) {
                    if ((this.vertexType & 0xC00) != 1024) break;
                    this.vertexType &= 0xFFFFFBFF;
                    this.mirrorFloatRefNormals = null;
                    this.mirrorNormalAllocated = false;
                    break;
                }
                this.vertexType |= 0x400;
                this.mirrorFloatRefNormals = this.floatRefNormals;
                this.mirrorNormalAllocated = false;
                break;
            }
            case 2048: {
                if (this.v3fRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 2048) {
                        this.vertexType &= 0xFFFFF7FF;
                    }
                    return;
                }
                this.vertexType |= 0x800;
                if (!this.mirrorNormalAllocated) {
                    this.mirrorFloatRefNormals = new float[this.vertexCount * 3];
                    this.mirrorNormalAllocated = true;
                }
                int n3 = this.initialNormalIndex * 3;
                for (int i2 = this.initialNormalIndex; i2 < this.validVertexCount; ++i2) {
                    this.mirrorFloatRefNormals[n3++] = this.v3fRefNormals[i2].x;
                    this.mirrorFloatRefNormals[n3++] = this.v3fRefNormals[i2].y;
                    this.mirrorFloatRefNormals[n3++] = this.v3fRefNormals[i2].z;
                }
                break;
            }
        }
    }

    void setupMirrorTexCoordPointer(int n2) {
        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
            this.doSetupMirrorTexCoordPointer(i2, n2);
        }
        this.validateTexCoordPointerType();
    }

    void setupMirrorTexCoordPointer(int n2, int n3) {
        this.doSetupMirrorTexCoordPointer(n2, n3);
        this.validateTexCoordPointerType();
    }

    private void validateTexCoordPointerType() {
        boolean bl = true;
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
            if (this.refTexCoords[i2] == null) {
                bl = false;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            this.texCoordType = 0;
        }
        this.vertexType &= 0xFFFF8FFF;
        if (bl) {
            this.vertexType |= this.texCoordType;
        }
    }

    private void doSetupMirrorTexCoordPointer(int n2, int n3) {
        switch (n3) {
            case 4096: {
                this.texCoordType = 4096;
                this.mirrorRefTexCoords[n2] = this.refTexCoords[n2];
                break;
            }
            case 8192: {
                this.texCoordType = 8192;
                this.t2fRefTexCoords = (TexCoord2f[])this.refTexCoords[n2];
                if (this.t2fRefTexCoords == null) {
                    this.mirrorRefTexCoords[n2] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n2];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 2) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                        this.mirrorRefTexCoords[n2] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                    this.mirrorRefTexCoords[n2] = this.mirrorFloatRefTexCoords;
                }
                int n4 = this.initialTexCoordIndex[n2] * 2;
                for (int i2 = this.initialTexCoordIndex[n2]; i2 < this.validVertexCount; ++i2) {
                    this.mirrorFloatRefTexCoords[n4++] = this.t2fRefTexCoords[i2].x;
                    this.mirrorFloatRefTexCoords[n4++] = this.t2fRefTexCoords[i2].y;
                }
                break;
            }
            case 16384: {
                this.texCoordType = 16384;
                this.t3fRefTexCoords = (TexCoord3f[])this.refTexCoords[n2];
                if (this.t3fRefTexCoords == null) {
                    this.mirrorRefTexCoords[n2] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n2];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 3) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                        this.mirrorRefTexCoords[n2] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                    this.mirrorRefTexCoords[n2] = this.mirrorFloatRefTexCoords;
                }
                int n5 = this.initialTexCoordIndex[n2] * 3;
                for (int i3 = this.initialTexCoordIndex[n2]; i3 < this.validVertexCount; ++i3) {
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[i3].x;
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[i3].y;
                    this.mirrorFloatRefTexCoords[n5++] = this.t3fRefTexCoords[i3].z;
                }
                break;
            }
        }
    }

    void setupMirrorVertexAttrPointer(int n2) {
        for (int i2 = 0; i2 < this.vertexAttrCount; ++i2) {
            this.doSetupMirrorVertexAttrPointer(i2, n2);
        }
        this.validateVertexAttrPointerType();
    }

    void setupMirrorVertexAttrPointer(int n2, int n3) {
        this.doSetupMirrorVertexAttrPointer(n2, n3);
        this.validateVertexAttrPointerType();
    }

    private void validateVertexAttrPointerType() {
        boolean bl = true;
        boolean bl2 = true;
        if ((this.vertexFormat & 0x800) == 0) {
            for (int i2 = 0; i2 < this.vertexAttrCount; ++i2) {
                if (this.floatRefVertexAttrs[i2] == null) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
        } else {
            for (int i3 = 0; i3 < this.vertexAttrCount; ++i3) {
                if (this.nioFloatBufferRefVertexAttrs[i3] == null) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.vertexAttrType = 0;
        }
        this.vertexType &= 0xFFFF7FFF;
        if (bl) {
            this.vertexType |= this.vertexAttrType;
        }
    }

    private void doSetupMirrorVertexAttrPointer(int n2, int n3) {
        switch (n3) {
            case 32768: {
                this.vertexAttrType = 32768;
                this.mirrorFloatRefVertexAttrs[n2] = this.floatRefVertexAttrs[n2];
                break;
            }
        }
    }

    void createGeometryArrayData(int n2, int n3) {
        if ((n3 & 0x460) != 0) {
            this.createGeometryArrayData(n2, n3, 1, defaultTexCoordSetMap);
        } else {
            this.createGeometryArrayData(n2, n3, 0, null);
        }
    }

    void createGeometryArrayData(int n2, int n3, int n4, int[] nArray) {
        this.createGeometryArrayData(n2, n3, n4, nArray, 0, null);
    }

    void createGeometryArrayData(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2) {
        this.vertexFormat = n3;
        this.vertexCount = n2;
        this.validVertexCount = n2;
        this.texCoordSetCount = n4;
        this.texCoordSetMap = (int[])(nArray == null ? null : (int[])nArray.clone());
        this.vertexAttrCount = n5;
        this.vertexAttrSizes = (int[])(nArray2 == null ? null : (int[])nArray2.clone());
        this.vertexAttrStride = this.vertexAttrStride();
        this.stride = this.stride();
        this.vertexAttrOffsets = this.vertexAttrOffsets();
        this.texCoordSetMapOffset = this.texCoordSetMapOffset();
        this.textureOffset = this.textureOffset();
        this.colorOffset = this.colorOffset();
        this.normalOffset = this.normalOffset();
        this.coordinateOffset = this.coordinateOffset();
        if ((n3 & 0x80) == 0) {
            this.vertexData = new float[this.vertexCount * this.stride];
        } else {
            this.vertexData = null;
            if ((n3 & 0x460) != 0) {
                this.mirrorRefTexCoords = new Object[n4];
                this.refTexCoords = new Object[n4];
                if ((n3 & 0x800) != 0) {
                    this.refTexCoordsBuffer = new Object[n4];
                }
            }
            if ((n3 & 0x1000) != 0) {
                this.floatRefVertexAttrs = new float[n5][];
                this.mirrorFloatRefVertexAttrs = new float[n5][];
                if ((n3 & 0x800) != 0) {
                    this.vertexAttrsRefBuffer = new J3DBuffer[n5];
                    this.floatBufferRefVertexAttrs = new FloatBufferWrapper[n5];
                    this.nioFloatBufferRefVertexAttrs = new Object[n5];
                }
            }
        }
        if ((n3 & 0x460) != 0) {
            this.initialTexCoordIndex = new int[n4];
        }
        if ((n3 & 0x1000) != 0) {
            this.initialVertexAttrIndex = new int[n5];
        }
        this.noAlpha = (n3 & 8) == 0;
        this.lastAlpha[0] = 1.0f;
    }

    void setVertexFormat(boolean bl, boolean bl2, Context context) {
        Pipeline.getPipeline().setVertexFormat(context, this, this.vertexFormat, bl, bl2);
    }

    void disableGlobalAlpha(Context context, boolean bl, boolean bl2) {
        Pipeline.getPipeline().disableGlobalAlpha(context, this, this.vertexFormat, bl, bl2);
    }

    float[] updateAlphaInFloatRefColors(Canvas3D canvas3D, int n2, float f2) {
        int n3;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f2);
            return this.mirrorFloatRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorFloatRefColors[0];
        }
        if ((double)f2 <= 1.0E-6) {
            f2 = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorFloatRefColors != null);
        assert (this.mirrorFloatRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n2) {
            object = new float[n2 + 1];
            for (n3 = 0; n3 < this.lastAlpha.length; ++n3) {
                object[n3] = this.lastAlpha[n3];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorFloatRefColors.length <= n2) {
            object = new float[n2 + 1][];
            for (n3 = 0; n3 < this.mirrorFloatRefColors.length; ++n3) {
                object[n3] = (float)this.mirrorFloatRefColors[n3];
            }
            for (n3 = this.mirrorFloatRefColors.length; n3 < n2 + 1; ++n3) {
                object[n3] = (float)new float[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n3], 0, 4 * this.vertexCount);
                this.lastAlpha[n3] = this.lastAlpha[0];
            }
            this.mirrorFloatRefColors = (float[][])object;
        }
        assert ((double)this.lastAlpha[n2] >= 0.0);
        if ((this.colorChanged & 1 << n2) == 0) {
            if ((double)Math.abs(this.lastAlpha[n2] - f2) <= 1.0E-6) {
                return this.mirrorFloatRefColors[n2];
            }
            float f3 = f2 / this.lastAlpha[n2];
            float[] fArray = this.mirrorFloatRefColors[n2];
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.vertexCount) {
                fArray[n5 + 3] = fArray[n5 + 3] * f3;
                ++n4;
                n5 += 4;
            }
        } else if (n2 == 0) {
            object = this.mirrorFloatRefColors[n2];
            n3 = this.initialColorIndex * 4;
            int n6 = this.initialColorIndex;
            while (n6 < this.validVertexCount) {
                object[n3 + 3] = object[n3 + 3] * f2;
                ++n6;
                n3 += 4;
            }
        } else {
            float f4 = (this.colorChanged & 1) == 0 ? f2 / this.lastAlpha[0] : f2;
            float[] fArray = this.mirrorFloatRefColors[0];
            float[] fArray2 = this.mirrorFloatRefColors[n2];
            int n7 = this.initialColorIndex * 4;
            for (int i2 = this.initialColorIndex; i2 < this.validVertexCount; ++i2) {
                fArray2[n7] = fArray[n7++];
                fArray2[n7] = fArray[n7++];
                fArray2[n7] = fArray[n7++];
                fArray2[n7] = fArray[n7++] * f4;
            }
        }
        this.lastAlpha[n2] = f2;
        this.colorChanged &= ~(1 << n2);
        this.dirtyFlag |= 4;
        return this.mirrorFloatRefColors[n2];
    }

    byte[] updateAlphaInByteRefColors(Canvas3D canvas3D, int n2, float f2) {
        int n3;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f2);
            return this.mirrorUnsignedByteRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorUnsignedByteRefColors[0];
        }
        if ((double)f2 <= 1.0E-6) {
            f2 = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorUnsignedByteRefColors != null);
        assert (this.mirrorUnsignedByteRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n2) {
            object = new float[n2 + 1];
            for (n3 = 0; n3 < this.lastAlpha.length; ++n3) {
                object[n3] = this.lastAlpha[n3];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorUnsignedByteRefColors.length <= n2) {
            object = new byte[n2 + 1][];
            for (n3 = 0; n3 < this.mirrorUnsignedByteRefColors.length; ++n3) {
                object[n3] = (float)this.mirrorUnsignedByteRefColors[n3];
            }
            for (n3 = this.mirrorUnsignedByteRefColors.length; n3 < n2 + 1; ++n3) {
                object[n3] = (float)new byte[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n3], 0, 4 * this.vertexCount);
                this.lastAlpha[n3] = this.lastAlpha[0];
            }
            this.mirrorUnsignedByteRefColors = (byte[][])object;
        }
        assert ((double)this.lastAlpha[n2] >= 0.0);
        if ((this.colorChanged & 1 << n2) == 0) {
            if ((double)Math.abs(this.lastAlpha[n2] - f2) <= 1.0E-6) {
                return this.mirrorUnsignedByteRefColors[n2];
            }
            float f3 = f2 / this.lastAlpha[n2];
            byte[] byArray = this.mirrorUnsignedByteRefColors[n2];
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.vertexCount) {
                byArray[n5 + 3] = (byte)((float)(byArray[n5 + 3] & 0xFF) * f3);
                ++n4;
                n5 += 4;
            }
        } else if (n2 == 0) {
            object = this.mirrorUnsignedByteRefColors[n2];
            n3 = this.initialColorIndex * 4;
            int n6 = this.initialColorIndex;
            while (n6 < this.validVertexCount) {
                object[n3 + 3] = (byte)((float)(object[n3 + 3] & 0xFF) * f2);
                ++n6;
                n3 += 4;
            }
        } else {
            float f4 = (this.colorChanged & 1) == 0 ? f2 / this.lastAlpha[0] : f2;
            byte[] byArray = this.mirrorUnsignedByteRefColors[0];
            byte[] byArray2 = this.mirrorUnsignedByteRefColors[n2];
            int n7 = this.initialColorIndex * 4;
            for (int i2 = this.initialColorIndex; i2 < this.validVertexCount; ++i2) {
                byArray2[n7] = byArray[n7++];
                byArray2[n7] = byArray[n7++];
                byArray2[n7] = byArray[n7++];
                byArray2[n7] = (byte)((float)(byArray[n7++] & 0xFF) * f4);
            }
        }
        this.lastAlpha[n2] = f2;
        this.colorChanged &= ~(1 << n2);
        this.dirtyFlag |= 4;
        return this.mirrorUnsignedByteRefColors[n2];
    }

    Object[] updateAlphaInVertexData(Canvas3D canvas3D, int n2, float f2) {
        int n3;
        int n4;
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f2);
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((this.vertexFormat & 4) == 0) {
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((double)f2 <= 1.0E-6) {
            f2 = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mvertexData == null || this.mvertexData.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n2) {
            object = new float[n2 + 1];
            for (n4 = 0; n4 < this.lastAlpha.length; ++n4) {
                object[n4] = this.lastAlpha[n4];
            }
            this.lastAlpha = object;
        }
        if (this.mvertexData == null || this.mvertexData.length <= n2) {
            object = new float[n2 + 1][];
            n4 = 1;
            if (this.mvertexData != null) {
                n4 = this.mvertexData.length;
                for (n3 = 0; n3 < this.mvertexData.length; ++n3) {
                    object[n3] = (float)this.mvertexData[n3];
                }
            }
            if (object[0] == null) {
                object[0] = (float)this.vertexData;
            }
            if (n2 > 0) {
                for (n3 = n4; n3 < n2 + 1; ++n3) {
                    object[n3] = (float)new float[this.stride * this.vertexCount];
                    System.arraycopy(object[0], 0, object[n3], 0, this.stride * this.vertexCount);
                    this.lastAlpha[n3] = this.lastAlpha[0];
                }
            }
            this.mvertexData = (float[][])object;
        }
        assert ((double)this.lastAlpha[n2] >= 0.0);
        if ((this.colorChanged & 1 << n2) == 0) {
            if ((double)Math.abs(this.lastAlpha[n2] - f2) <= 1.0E-6) {
                objectArray[1] = this.mvertexData[n2];
                return objectArray;
            }
            float f3 = f2 / this.lastAlpha[n2];
            float[] fArray = this.mvertexData[n2];
            n3 = 0;
            int n5 = this.colorOffset;
            while (n3 < this.vertexCount) {
                int n6 = n5 + 3;
                fArray[n6] = fArray[n6] * f3;
                ++n3;
                n5 += this.stride;
            }
        } else if (n2 == 0) {
            object = this.mvertexData[n2];
            double d2 = f2 / this.lastAlpha[0];
            int n7 = 0;
            int n8 = this.colorOffset;
            while (n7 < this.vertexCount) {
                int n9 = n8 + 3;
                object[n9] = (float)((double)object[n9] * d2);
                ++n7;
                n8 += this.stride;
            }
        } else {
            float f4 = f2 / this.lastAlpha[0];
            float[] fArray = this.mvertexData[0];
            float[] fArray2 = this.mvertexData[n2];
            int n10 = 0;
            int n11 = this.colorOffset;
            while (n10 < this.vertexCount) {
                System.arraycopy(fArray, n11, fArray2, n11, 3);
                fArray2[n11 + 3] = fArray[n11 + 3] * f4;
                ++n10;
                n11 += this.stride;
            }
        }
        this.lastAlpha[n2] = f2;
        this.colorChanged &= ~(1 << n2);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mvertexData[n2];
        return objectArray;
    }

    Object[] updateAlphaInInterLeavedData(Canvas3D canvas3D, int n2, float f2) {
        int n3;
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f2);
            objectArray[1] = null;
            return objectArray;
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            objectArray[1] = this.mirrorInterleavedColorPointer[0];
            return objectArray;
        }
        int n4 = this.initialColorIndex << 2;
        if ((double)f2 <= 1.0E-6) {
            f2 = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mirrorInterleavedColorPointer != null);
        assert (this.mirrorInterleavedColorPointer.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n2) {
            object = new float[n2 + 1];
            for (n3 = 0; n3 < this.lastAlpha.length; ++n3) {
                object[n3] = this.lastAlpha[n3];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorInterleavedColorPointer.length <= n2) {
            object = new float[n2 + 1][];
            for (n3 = 0; n3 < this.mirrorInterleavedColorPointer.length; ++n3) {
                object[n3] = (float)this.mirrorInterleavedColorPointer[n3];
            }
            for (n3 = this.mirrorInterleavedColorPointer.length; n3 < n2 + 1; ++n3) {
                object[n3] = (float)new float[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n3], 0, 4 * this.vertexCount);
                this.lastAlpha[n3] = this.lastAlpha[0];
            }
            this.mirrorInterleavedColorPointer = (float[][])object;
        }
        assert ((double)this.lastAlpha[n2] >= 0.0);
        if ((this.colorChanged & 1 << n2) == 0) {
            if ((double)Math.abs(this.lastAlpha[n2] - f2) <= 1.0E-6) {
                objectArray[1] = this.mirrorInterleavedColorPointer[n2];
                return objectArray;
            }
            float f3 = f2 / this.lastAlpha[n2];
            float[] fArray = this.mirrorInterleavedColorPointer[n2];
            for (int i2 = n4 = this.initialColorIndex << 2; i2 < n4 + (this.vertexCount << 2); i2 += 4) {
                fArray[i2 + 3] = fArray[i2 + 3] * f3;
            }
        } else if (n2 == 0) {
            object = this.mirrorInterleavedColorPointer[n2];
            for (n3 = n4; n3 < n4 + (this.vertexCount << 2); n3 += 4) {
                object[n3 + 3] = object[n3 + 3] * f2;
            }
        } else {
            float f4 = (this.colorChanged & 1) == 0 ? f2 / this.lastAlpha[0] : f2;
            float[] fArray = this.mirrorInterleavedColorPointer[0];
            float[] fArray2 = this.mirrorInterleavedColorPointer[n2];
            int n5 = n4;
            while (n5 < n4 + (this.vertexCount << 2)) {
                fArray2[n5] = fArray[n5++];
                fArray2[n5] = fArray[n5++];
                fArray2[n5] = fArray[n5++];
                fArray2[n5] = fArray[n5++] * f4;
            }
        }
        this.lastAlpha[n2] = f2;
        this.colorChanged &= ~(1 << n2);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mirrorInterleavedColorPointer[n2];
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f2, int n2, boolean bl3) {
        boolean bl4 = false;
        if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            int n3;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n3 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n2, f2);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f2 != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f2;
                        n3 |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n3 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().execute(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, fArray, null, n3);
        } else if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n4;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                GeometryArrayRetained geometryArrayRetained = this;
                synchronized (geometryArrayRetained) {
                    n4 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n2, f2);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n4 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n4 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().execute(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, this.interLeavedVertexData, fArray, n4);
            } else {
                int n5;
                GeometryArrayRetained geometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n2, f2);
                            if (f2 != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f2;
                                n5 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n2, f2);
                            if (f2 != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f2;
                                n5 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n5 = this.dirtyFlag;
                }
                int n6 = 0;
                if ((this.vertexType & 5) != 0) {
                    n6 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n6 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n6 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n6 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n6 |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n6 |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n6 |= 0x20;
                }
                Pipeline.getPipeline().executeVA(canvas3D.ctx, this, this.geoType, bl, bl3, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n6, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, fArray, byArray, this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, n5);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n7;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n7 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n2, f2);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f2 != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f2;
                        n7 |= 4;
                    }
                } else {
                    fArray = null;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n7 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeInterleavedBuffer(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interleavedFloatBufferImpl.getBufferAsObject(), fArray, n7);
        } else {
            int n8;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n2, f2);
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n8 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n2, f2);
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n8 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n8 = this.dirtyFlag;
            }
            object = null;
            Object object2 = null;
            Object object3 = null;
            int n9 = 0;
            if ((this.vertexType & 1) != 0) {
                n9 |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n9 |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n9 |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n9 |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n9 |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x8000) != 0) {
                n9 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                n9 |= 0x20;
            }
            Pipeline.getPipeline().executeVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n9, this.initialCoordIndex, object, this.initialColorIndex, object2, fArray, byArray, this.initialNormalIndex, object3, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.nioFloatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.refTexCoords, n8);
        }
    }

    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f2, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        float[] fArray = null;
        assert ((this.vertexFormat & 0x800) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            fArray = this.vertexData;
        } else if ((this.vertexFormat & 0x100) != 0 && (this.vertexFormat & 0x800) == 0) {
            fArray = this.interLeavedVertexData;
        }
        if (fArray != null) {
            Pipeline.getPipeline().buildGA(canvas3D.ctx, this, this.geoType, bl, bl2, f2, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, this.vertexAttrCount, this.vertexAttrSizes, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray);
        } else {
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                int n2 = 0;
                if ((this.vertexType & 5) != 0) {
                    n2 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n2 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n2 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n2 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n2 |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n2 |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n2 |= 0x20;
                }
                Pipeline.getPipeline().buildGAForByRef(canvas3D.ctx, this, this.geoType, bl, bl2, f2, bl3, this.validVertexCount, this.vertexFormat, n2, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, this.mirrorFloatRefColors[0], this.mirrorUnsignedByteRefColors[0], this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat);
            }
        }
    }

    void unIndexify(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        if ((indexedGeometryArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryArrayRetained);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float[] fArray = null;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex;
        int n6 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryArrayRetained.vertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 4;
                }
            } else if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryArrayRetained.interLeavedVertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n4 = 4;
                } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n4 = 3;
                }
            }
            for (int i2 = n5; i2 < n6; ++i2) {
                int n7;
                int n8;
                if ((this.vertexFormat & 2) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexNormal[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset, this.vertexData, n2 + this.normalOffset, 3);
                }
                if (n4 == 4) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n2 + this.colorOffset, n4);
                } else if (n4 == 3) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n2 + this.colorOffset, n4);
                    this.vertexData[n2 + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    n8 = n2 + this.textureOffset;
                    int n9 = 0;
                    n7 = 0;
                    while (n7 < this.texCoordSetCount) {
                        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                            n9 = n7 * this.texCoordStride;
                        }
                        System.arraycopy(fArray, indexedGeometryArrayRetained.indexTexCoord[n7][i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset + n9, this.vertexData, n8, this.texCoordStride);
                        ++n7;
                        n8 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 0x1000) != 0) {
                    assert ((indexedGeometryArrayRetained.vertexFormat & 0x100) == 0);
                    for (n7 = 0; n7 < this.vertexAttrCount; ++n7) {
                        n8 = n2 + this.vertexAttrOffsets[n7];
                        System.arraycopy(fArray, indexedGeometryArrayRetained.indexVertexAttr[n7][i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.vertexAttrOffsets[n7], this.vertexData, n8, this.vertexAttrSizes[n7]);
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexCoord[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset, this.vertexData, n2 + this.coordinateOffset, 3);
                }
                n2 += this.stride;
            }
        } else {
            int n10;
            int n11;
            int n12;
            int n13;
            if ((this.vertexFormat & 2) != 0) {
                n2 = this.normalOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefNormals, indexedGeometryArrayRetained.indexNormal[n13] * 3, this.vertexData, n2, 3);
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 2048: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexNormal[n13];
                            this.vertexData[n2] = indexedGeometryArrayRetained.v3fRefNormals[n12].x;
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.v3fRefNormals[n12].y;
                            this.vertexData[n2 + 2] = indexedGeometryArrayRetained.v3fRefNormals[n12].z;
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n2 = this.colorOffset;
                n11 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n11 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n13] * n11, this.vertexData, n2, 4);
                            } else {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n13] * n11, this.vertexData, n2, 3);
                                this.vertexData[n2 + 3] = 1.0f;
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexColor[n13] * n11;
                            this.vertexData[n2] = (float)(indexedGeometryArrayRetained.byteRefColors[n12] & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 1] = (float)(indexedGeometryArrayRetained.byteRefColors[n12 + 1] & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 2] = (float)(indexedGeometryArrayRetained.byteRefColors[n12 + 2] & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteRefColors[n12 + 3] & 0xFF) * 0.003921569f : 1.0f;
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 64: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexColor[n13];
                            this.vertexData[n2] = indexedGeometryArrayRetained.c3fRefColors[n12].x;
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.c3fRefColors[n12].y;
                            this.vertexData[n2 + 2] = indexedGeometryArrayRetained.c3fRefColors[n12].z;
                            this.vertexData[n2 + 3] = 1.0f;
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 128: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexColor[n13];
                            this.vertexData[n2] = indexedGeometryArrayRetained.c4fRefColors[n12].x;
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.c4fRefColors[n12].y;
                            this.vertexData[n2 + 2] = indexedGeometryArrayRetained.c4fRefColors[n12].z;
                            this.vertexData[n2 + 3] = indexedGeometryArrayRetained.c4fRefColors[n12].w;
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 256: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexColor[n13];
                            this.vertexData[n2] = (float)(indexedGeometryArrayRetained.c3bRefColors[n12].x & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 1] = (float)(indexedGeometryArrayRetained.c3bRefColors[n12].y & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 2] = (float)(indexedGeometryArrayRetained.c3bRefColors[n12].z & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 3] = 1.0f;
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 512: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexColor[n13];
                            this.vertexData[n2] = (float)(indexedGeometryArrayRetained.c4bRefColors[n12].x & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 1] = (float)(indexedGeometryArrayRetained.c4bRefColors[n12].y & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 2] = (float)(indexedGeometryArrayRetained.c4bRefColors[n12].z & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 3] = (float)(indexedGeometryArrayRetained.c4bRefColors[n12].w & 0xFF) * 0.003921569f;
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n2 = this.textureOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n3 = n2;
                            for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                System.arraycopy(indexedGeometryArrayRetained.refTexCoords[n10], indexedGeometryArrayRetained.indexTexCoord[n10][n13] * this.texCoordStride, this.vertexData, n3, this.texCoordStride);
                                n3 += this.texCoordStride;
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 8192: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n3 = n2;
                            for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                n12 = indexedGeometryArrayRetained.indexTexCoord[n10][n13];
                                this.vertexData[n3] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n10])[n12].x;
                                this.vertexData[n3 + 1] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n10])[n12].y;
                                n3 += this.texCoordStride;
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 16384: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n3 = n2;
                            for (n10 = 0; n10 < this.texCoordSetCount; ++n10) {
                                n12 = indexedGeometryArrayRetained.indexTexCoord[n10][n13];
                                this.vertexData[n3] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n12].x;
                                this.vertexData[n3 + 1] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n12].y;
                                this.vertexData[n3 + 2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n10])[n12].z;
                                n3 += this.texCoordStride;
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n2 = 0;
                switch (indexedGeometryArrayRetained.vertexType & 0x8000) {
                    case 32768: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            for (n10 = 0; n10 < this.vertexAttrCount; ++n10) {
                                n11 = n2 + this.vertexAttrOffsets[n10];
                                System.arraycopy(indexedGeometryArrayRetained.floatRefVertexAttrs[n10], indexedGeometryArrayRetained.indexVertexAttr[n10][n13] * this.vertexAttrSizes[n10], this.vertexData, n11, this.vertexAttrSizes[n10]);
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n2 = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefCoords, indexedGeometryArrayRetained.indexCoord[n13] * 3, this.vertexData, n2, 3);
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexCoord[n13] * 3;
                            this.vertexData[n2] = (float)indexedGeometryArrayRetained.doubleRefCoords[n12];
                            this.vertexData[n2 + 1] = (float)indexedGeometryArrayRetained.doubleRefCoords[n12 + 1];
                            this.vertexData[n2 + 2] = (float)indexedGeometryArrayRetained.doubleRefCoords[n12 + 2];
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 4: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexCoord[n13];
                            this.vertexData[n2] = indexedGeometryArrayRetained.p3fRefCoords[n12].x;
                            this.vertexData[n2 + 1] = indexedGeometryArrayRetained.p3fRefCoords[n12].y;
                            this.vertexData[n2 + 2] = indexedGeometryArrayRetained.p3fRefCoords[n12].z;
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 8: {
                        for (n13 = n5; n13 < n6; ++n13) {
                            n12 = indexedGeometryArrayRetained.indexCoord[n13];
                            this.vertexData[n2] = (float)indexedGeometryArrayRetained.p3dRefCoords[n12].x;
                            this.vertexData[n2 + 1] = (float)indexedGeometryArrayRetained.p3dRefCoords[n12].y;
                            this.vertexData[n2 + 2] = (float)indexedGeometryArrayRetained.p3dRefCoords[n12].z;
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object var7_5 = null;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex;
        int n6 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                n4 = 4;
            } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                n4 = 3;
            }
            for (int i2 = n5; i2 < n6; ++i2) {
                if ((this.vertexFormat & 2) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexNormal[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.normalOffset, 3);
                }
                if (n4 == 4) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.colorOffset, n4);
                } else if (n4 == 3) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.colorOffset, n4);
                    this.vertexData[n2 + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n7 = n2 + this.textureOffset;
                    int n8 = 0;
                    while (n8 < this.texCoordSetCount) {
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexTexCoord[n8][i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset);
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n7, this.texCoordStride);
                        ++n8;
                        n7 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexCoord[i2] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n2 + this.coordinateOffset, 3);
                }
                n2 += this.stride;
            }
        } else {
            int n9;
            int n10;
            int n11;
            if ((this.vertexFormat & 2) != 0) {
                n2 = this.normalOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0xC00) != 0) {
                    for (n11 = n5; n11 < n6; ++n11) {
                        indexedGeometryArrayRetained.floatBufferRefNormals.position(indexedGeometryArrayRetained.indexNormal[n11] * 3);
                        indexedGeometryArrayRetained.floatBufferRefNormals.get(this.vertexData, n2, 3);
                        n2 += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n2 = this.colorOffset;
                int n12 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n12 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n11 = n5; n11 < n6; ++n11) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n11] * n12);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n2, 4);
                            } else {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n11] * n12);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n2, 3);
                                this.vertexData[n2 + 3] = 1.0f;
                            }
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (n11 = n5; n11 < n6; ++n11) {
                            n10 = indexedGeometryArrayRetained.indexColor[n11] * n12;
                            this.vertexData[n2] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n10) & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 1] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n10 + 1) & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 2] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n10 + 2) & 0xFF) * 0.003921569f;
                            this.vertexData[n2 + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n10 + 3) & 0xFF) * 0.003921569f : 1.0f;
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n2 = this.textureOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0x7000) != 0) {
                    for (n11 = n5; n11 < n6; ++n11) {
                        n3 = n2;
                        for (n9 = 0; n9 < this.texCoordSetCount; ++n9) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryArrayRetained.refTexCoordsBuffer[n9]).getBufferImpl();
                            floatBufferWrapper.position(indexedGeometryArrayRetained.indexTexCoord[n9][n11] * this.texCoordStride);
                            floatBufferWrapper.get(this.vertexData, n3, this.texCoordStride);
                            n3 += this.texCoordStride;
                        }
                        n2 += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n2 = 0;
                if ((indexedGeometryArrayRetained.vertexType & 0x8000) == 32768) {
                    for (n11 = n5; n11 < n6; ++n11) {
                        for (n9 = 0; n9 < this.vertexAttrCount; ++n9) {
                            int n13 = n2 + this.vertexAttrOffsets[n9];
                            FloatBufferWrapper floatBufferWrapper = indexedGeometryArrayRetained.floatBufferRefVertexAttrs[n9];
                            floatBufferWrapper.position(indexedGeometryArrayRetained.indexVertexAttr[n9][n11] * this.vertexAttrSizes[n9]);
                            floatBufferWrapper.get(this.vertexData, n13, this.vertexAttrSizes[n9]);
                        }
                        n2 += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n2 = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n11 = n5; n11 < n6; ++n11) {
                            indexedGeometryArrayRetained.floatBufferRefCoords.position(indexedGeometryArrayRetained.indexCoord[n11] * 3);
                            indexedGeometryArrayRetained.floatBufferRefCoords.get(this.vertexData, n2, 3);
                            n2 += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (n11 = n5; n11 < n6; ++n11) {
                            n10 = indexedGeometryArrayRetained.indexCoord[n11] * 3;
                            this.vertexData[n2] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n10);
                            this.vertexData[n2 + 1] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n10 + 1);
                            this.vertexData[n2 + 2] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n10 + 2);
                            n2 += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    int stride() {
        int n2 = 0;
        if ((this.vertexFormat & 1) != 0) {
            n2 += 3;
        }
        if ((this.vertexFormat & 2) != 0) {
            n2 += 3;
        }
        if ((this.vertexFormat & 4) != 0) {
            n2 = (this.vertexFormat & 0x80) == 0 ? (n2 += 4) : ((this.vertexFormat & 8) == 0 ? (n2 += 3) : (n2 += 4));
        }
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x20) != 0) {
                this.texCoordStride = 2;
            } else if ((this.vertexFormat & 0x40) != 0) {
                this.texCoordStride = 3;
            } else if ((this.vertexFormat & 0x400) != 0) {
                this.texCoordStride = 4;
            }
            n2 += this.texCoordStride * this.texCoordSetCount;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            n2 += this.vertexAttrStride;
        }
        return n2;
    }

    int[] texCoordSetMapOffset() {
        if (this.texCoordSetMap == null) {
            return null;
        }
        this.texCoordSetMapOffset = new int[this.texCoordSetMap.length];
        for (int i2 = 0; i2 < this.texCoordSetMap.length; ++i2) {
            this.texCoordSetMapOffset[i2] = this.texCoordSetMap[i2] == -1 ? -1 : this.texCoordSetMap[i2] * this.texCoordStride;
        }
        return this.texCoordSetMapOffset;
    }

    int vertexAttrStride() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.vertexAttrCount; ++i2) {
            n2 += this.vertexAttrSizes[i2];
        }
        return n2;
    }

    int[] vertexAttrOffsets() {
        int[] nArray = this.vertexAttrCount > 0 ? new int[this.vertexAttrCount] : new int[]{0};
        for (int i2 = 1; i2 < this.vertexAttrCount; ++i2) {
            nArray[i2] = nArray[i2 - 1] + this.vertexAttrSizes[i2 - 1];
        }
        return nArray;
    }

    int textureOffset() {
        int n2 = this.vertexAttrOffsets[0];
        if ((this.vertexFormat & 0x1000) != 0) {
            n2 += this.vertexAttrStride;
        }
        return n2;
    }

    int colorOffset() {
        int n2 = this.textureOffset;
        if ((this.vertexFormat & 0x20) != 0) {
            n2 += 2 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x40) != 0) {
            n2 += 3 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x400) != 0) {
            n2 += 4 * this.texCoordSetCount;
        }
        return n2;
    }

    int normalOffset() {
        int n2 = this.colorOffset;
        if ((this.vertexFormat & 4) != 0) {
            n2 = (this.vertexFormat & 0x80) == 0 ? (n2 += 4) : ((this.vertexFormat & 8) == 0 ? (n2 += 3) : (n2 += 4));
        }
        return n2;
    }

    int coordinateOffset() {
        int n2 = this.normalOffset;
        if ((this.vertexFormat & 2) != 0) {
            n2 += 3;
        }
        return n2;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getVertexFormat() {
        return this.vertexFormat;
    }

    int getVertexAttrCount() {
        return this.vertexAttrCount;
    }

    void getVertexAttrSizes(int[] nArray) {
        for (int i2 = 0; i2 < this.vertexAttrCount; ++i2) {
            nArray[i2] = this.vertexAttrSizes[i2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataChangedMessage(boolean bl) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source != null && this.source.isLive()) {
                Cloneable cloneable;
                int n2;
                int n3;
                int n4;
                int n5 = 128;
                n5 |= 0x400;
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int n6 = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n6];
                    n4 = 0;
                    n3 = 0;
                    while (n3 < n6) {
                        Shape3DRetained shape3DRetained;
                        this.gaList.clear();
                        ArrayList arrayList2 = (ArrayList)this.userLists.get(n3);
                        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n2);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (!bl || !((LeafRetained)cloneable).boundsAutoCompute) continue;
                            ((LeafRetained)cloneable).boundsDirty = true;
                        }
                        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n2);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (((LeafRetained)cloneable).boundsDirty) {
                                ((LeafRetained)cloneable).updateBounds();
                                ((LeafRetained)cloneable).boundsDirty = false;
                            }
                            this.gaList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                        }
                        j3dMessageArray[n4] = new J3dMessage();
                        j3dMessageArray[n4].type = 17;
                        j3dMessageArray[n4].threads = n5;
                        j3dMessageArray[n4].args[0] = this.gaList.toArray();
                        j3dMessageArray[n4].args[1] = this;
                        j3dMessageArray[n4].args[2] = null;
                        j3dMessageArray[n4].args[3] = new Integer(this.changedFrequent);
                        j3dMessageArray[n4].universe = (VirtualUniverse)this.universeList.get(n3);
                        ++n3;
                        ++n4;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
                if (this.morphUniverseList != null) {
                    arrayList = this.morphUniverseList;
                    synchronized (arrayList) {
                        int n7 = this.morphUniverseList.size();
                        if (n7 > 0) {
                            cloneable = this.morphUniverseList;
                            synchronized (cloneable) {
                                n3 = 0;
                                while (n3 < n7) {
                                    ArrayList arrayList3 = (ArrayList)this.morphUserLists.get(n3);
                                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                                        MorphRetained morphRetained = (MorphRetained)arrayList3.get(n2);
                                        morphRetained.updateMorphedGeometryArray(this, bl);
                                    }
                                    ++n3;
                                    ++n4;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void setCoordinate(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n3] = fArray[0];
        this.vertexData[n3 + 1] = fArray[1];
        this.vertexData[n3 + 2] = fArray[2];
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n2, double[] dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n3] = (float)dArray[0];
        this.vertexData[n3 + 1] = (float)dArray[1];
        this.vertexData[n3 + 2] = (float)dArray[2];
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n2, Point3f point3f) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n3] = point3f.x;
        this.vertexData[n3 + 1] = point3f.y;
        this.vertexData[n3 + 2] = point3f.z;
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n2, Point3d point3d) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.vertexData[n3] = (float)point3d.x;
        this.vertexData[n3 + 1] = (float)point3d.y;
        this.vertexData[n3 + 2] = (float)point3d.z;
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, double[] dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = dArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = (float)dArray[n5];
            this.vertexData[n6 + 1] = (float)dArray[n5 + 1];
            this.vertexData[n6 + 2] = (float)dArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = point3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = point3fArray[n5].x;
            this.vertexData[n6 + 1] = point3fArray[n5].y;
            this.vertexData[n6 + 2] = point3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, Point3d[] point3dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = point3dArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = (float)point3dArray[n5].x;
            this.vertexData[n6 + 1] = (float)point3dArray[n5].y;
            this.vertexData[n6 + 2] = (float)point3dArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, float[] fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n6 = n3 * 3;
        int n7 = n5;
        while (n6 < (n3 + n4) * 3) {
            this.vertexData[n7] = fArray[n6];
            this.vertexData[n7 + 1] = fArray[n6 + 1];
            this.vertexData[n7 + 2] = fArray[n6 + 2];
            n6 += 3;
            n7 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, double[] dArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n6 = n3 * 3;
        int n7 = n5;
        while (n6 < (n3 + n4) * 3) {
            this.vertexData[n7] = (float)dArray[n6];
            this.vertexData[n7 + 1] = (float)dArray[n6 + 1];
            this.vertexData[n7 + 2] = (float)dArray[n6 + 2];
            n6 += 3;
            n7 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, Point3f[] point3fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point3fArray[n6].x;
            this.vertexData[n7 + 1] = point3fArray[n6].y;
            this.vertexData[n7 + 2] = point3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n2, Point3d[] point3dArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.coordinateOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = (float)point3dArray[n6].x;
            this.vertexData[n7 + 1] = (float)point3dArray[n6].y;
            this.vertexData[n7 + 2] = (float)point3dArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        this.geomLock.unLock();
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!this.source.isLive()) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setColor(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = fArray[0];
        this.vertexData[n3 + 1] = fArray[1];
        this.vertexData[n3 + 2] = fArray[2];
        this.vertexData[n3 + 3] = (this.vertexFormat & 8) != 0 ? fArray[3] * this.lastAlpha[0] : this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n2, byte[] byArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = (float)(byArray[0] & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 1] = (float)(byArray[1] & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 2] = (float)(byArray[2] & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 3] = (this.vertexFormat & 8) != 0 ? (float)(byArray[3] & 0xFF) * 0.003921569f * this.lastAlpha[0] : this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n2, Color3f color3f) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = color3f.x;
        this.vertexData[n3 + 1] = color3f.y;
        this.vertexData[n3 + 2] = color3f.z;
        this.vertexData[n3 + 3] = this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n2, Color4f color4f) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = color4f.x;
        this.vertexData[n3 + 1] = color4f.y;
        this.vertexData[n3 + 2] = color4f.z;
        this.vertexData[n3 + 3] = color4f.w * this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n2, Color3b color3b) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = (float)(color3b.x & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 1] = (float)(color3b.y & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 2] = (float)(color3b.z & 0xFF) * 0.003921569f;
        this.vertexData[n3 + 3] = this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColor(int n2, Color4b color4b) {
        int n3 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n3] = (float)(color4b.x * 255) * 0.003921569f;
        this.vertexData[n3 + 1] = (float)(color4b.y * 255) * 0.003921569f;
        this.vertexData[n3 + 2] = (float)(color4b.z * 255) * 0.003921569f;
        this.vertexData[n3 + 3] = (float)(color4b.w & 0xFF) * 0.003921569f * this.lastAlpha[0];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                this.vertexData[n6] = fArray[n5];
                this.vertexData[n6 + 1] = fArray[n5 + 1];
                this.vertexData[n6 + 2] = fArray[n5 + 2];
                this.vertexData[n6 + 3] = fArray[n5 + 3] * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                this.vertexData[n8] = fArray[n7];
                this.vertexData[n8 + 1] = fArray[n7 + 1];
                this.vertexData[n8 + 2] = fArray[n7 + 2];
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, byte[] byArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = byArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                this.vertexData[n6] = (float)(byArray[n5] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 1] = (float)(byArray[n5 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 2] = (float)(byArray[n5 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 3] = (float)(byArray[n5 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                this.vertexData[n8] = (float)(byArray[n7] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 1] = (float)(byArray[n7 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 2] = (float)(byArray[n7 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color3f[] color3fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = color3fArray[n5].x;
            this.vertexData[n6 + 1] = color3fArray[n5].y;
            this.vertexData[n6 + 2] = color3fArray[n5].z;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color4f[] color4fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color4fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = color4fArray[n5].x;
            this.vertexData[n6 + 1] = color4fArray[n5].y;
            this.vertexData[n6 + 2] = color4fArray[n5].z;
            this.vertexData[n6 + 3] = color4fArray[n5].w * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color3b[] color3bArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color3bArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = (float)(color3bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color3bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color3bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color4b[] color4bArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color4bArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = (float)(color4bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color4bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color4bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = (float)(color4bArray[n5].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, float[] fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n6 = n3 * 4;
            int n7 = n5;
            while (n6 < (n3 + n4) * 4) {
                this.vertexData[n7] = fArray[n6];
                this.vertexData[n7 + 1] = fArray[n6 + 1];
                this.vertexData[n7 + 2] = fArray[n6 + 2];
                this.vertexData[n7 + 3] = fArray[n6 + 3] * this.lastAlpha[0];
                n6 += 4;
                n7 += this.stride;
            }
        } else {
            int n8 = n3 * 3;
            int n9 = n5;
            while (n8 < (n3 + n4) * 3) {
                this.vertexData[n9] = fArray[n8];
                this.vertexData[n9 + 1] = fArray[n8 + 1];
                this.vertexData[n9 + 2] = fArray[n8 + 2];
                this.vertexData[n9 + 3] = this.lastAlpha[0];
                n8 += 3;
                n9 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, byte[] byArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n6 = n3 * 4;
            int n7 = n5;
            while (n6 < (n3 + n4) * 4) {
                this.vertexData[n7] = (float)(byArray[n6] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 1] = (float)(byArray[n6 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 2] = (float)(byArray[n6 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 3] = (float)(byArray[n6 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n6 += 4;
                n7 += this.stride;
            }
        } else {
            int n8 = n3 * 3;
            int n9 = n5;
            while (n8 < (n3 + n4) * 3) {
                this.vertexData[n9] = (float)(byArray[n8] & 0xFF) * 0.003921569f;
                this.vertexData[n9 + 1] = (float)(byArray[n8 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n9 + 2] = (float)(byArray[n8 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n9 + 3] = this.lastAlpha[0];
                n8 += 3;
                n9 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color3f[] color3fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = color3fArray[n6].x;
            this.vertexData[n7 + 1] = color3fArray[n6].y;
            this.vertexData[n7 + 2] = color3fArray[n6].z;
            this.vertexData[n7 + 3] = this.lastAlpha[0];
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color4f[] color4fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = color4fArray[n6].x;
            this.vertexData[n7 + 1] = color4fArray[n6].y;
            this.vertexData[n7 + 2] = color4fArray[n6].z;
            this.vertexData[n7 + 3] = color4fArray[n6].w * this.lastAlpha[0];
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color3b[] color3bArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = (float)(color3bArray[n6].x & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 1] = (float)(color3bArray[n6].y & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 2] = (float)(color3bArray[n6].z & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 3] = this.lastAlpha[0];
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setColors(int n2, Color4b[] color4bArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.colorOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = (float)(color4bArray[n6].x & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 1] = (float)(color4bArray[n6].y & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 2] = (float)(color4bArray[n6].z & 0xFF) * 0.003921569f;
            this.vertexData[n7 + 3] = (float)(color4bArray[n6].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        this.geomLock.getLock();
        this.vertexData[n3] = fArray[0];
        this.vertexData[n3 + 1] = fArray[1];
        this.vertexData[n3 + 2] = fArray[2];
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormal(int n2, Vector3f vector3f) {
        int n3 = this.stride * n2 + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.vertexData[n3] = vector3f.x;
        this.vertexData[n3 + 1] = vector3f.y;
        this.vertexData[n3 + 2] = vector3f.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        int n4 = fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n2, Vector3f[] vector3fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        int n4 = vector3fArray.length;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            this.vertexData[n6] = vector3fArray[n5].x;
            this.vertexData[n6 + 1] = vector3fArray[n5].y;
            this.vertexData[n6 + 2] = vector3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n2, float[] fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n6 = n3 * 3;
        int n7 = n5;
        while (n6 < (n3 + n4) * 3) {
            this.vertexData[n7] = fArray[n6];
            this.vertexData[n7 + 1] = fArray[n6 + 1];
            this.vertexData[n7 + 2] = fArray[n6 + 2];
            n6 += 3;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setNormals(int n2, Vector3f[] vector3fArray, int n3, int n4) {
        int n5 = this.stride * n2 + this.normalOffset;
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = vector3fArray[n6].x;
            this.vertexData[n7 + 1] = vector3fArray[n6].y;
            this.vertexData[n7 + 2] = vector3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, float[] fArray, int n4, int n5) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x400) != 0) {
            int n7 = n4 * 4;
            int n8 = n6;
            for (int i2 = 0; i2 < n5; ++i2) {
                this.vertexData[n8] = fArray[n7++];
                this.vertexData[n8 + 1] = fArray[n7++];
                this.vertexData[n8 + 2] = fArray[n7++];
                this.vertexData[n8 + 3] = fArray[n7++];
                n8 += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n9 = n4 * 3;
            int n10 = n6;
            for (int i3 = 0; i3 < n5; ++i3) {
                this.vertexData[n10] = fArray[n9++];
                this.vertexData[n10 + 1] = fArray[n9++];
                this.vertexData[n10 + 2] = fArray[n9++];
                n10 += this.stride;
            }
        } else {
            int n11 = n4 * 2;
            int n12 = n6;
            for (int i4 = 0; i4 < n5; ++i4) {
                this.vertexData[n12] = fArray[n11++];
                this.vertexData[n12 + 1] = fArray[n11++];
                n12 += this.stride;
            }
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, Point2f[] point2fArray, int n4, int n5) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        int n7 = n4;
        int n8 = n6;
        while (n7 < n4 + n5) {
            this.vertexData[n8] = point2fArray[n7].x;
            this.vertexData[n8 + 1] = point2fArray[n7].y;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, Point3f[] point3fArray, int n4, int n5) {
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        int n7 = n4;
        int n8 = n6;
        while (n7 < n4 + n5) {
            this.vertexData[n8] = point3fArray[n7].x;
            this.vertexData[n8 + 1] = point3fArray[n7].y;
            this.vertexData[n8 + 2] = point3fArray[n7].z;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, TexCoord2f[] texCoord2fArray, int n4, int n5) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n7 = n4;
        int n8 = n6;
        while (n7 < n4 + n5) {
            this.vertexData[n8] = texCoord2fArray[n7].x;
            this.vertexData[n8 + 1] = texCoord2fArray[n7].y;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, TexCoord3f[] texCoord3fArray, int n4, int n5) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n7 = n4;
        int n8 = n6;
        while (n7 < n4 + n5) {
            this.vertexData[n8] = texCoord3fArray[n7].x;
            this.vertexData[n8 + 1] = texCoord3fArray[n7].y;
            this.vertexData[n8 + 2] = texCoord3fArray[n7].z;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setTextureCoordinates(int n2, int n3, TexCoord4f[] texCoord4fArray, int n4, int n5) {
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n6 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n7 = n4;
        int n8 = n6;
        while (n7 < n4 + n5) {
            this.vertexData[n8] = texCoord4fArray[n7].x;
            this.vertexData[n8 + 1] = texCoord4fArray[n7].y;
            this.vertexData[n8 + 2] = texCoord4fArray[n7].z;
            this.vertexData[n8 + 3] = texCoord4fArray[n7].w;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttr(int n2, int n3, Point2f point2f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.vertexData[n4] = point2f.x;
        this.vertexData[n4 + 1] = point2f.y;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttr(int n2, int n3, Point3f point3f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.vertexData[n4] = point3f.x;
        this.vertexData[n4 + 1] = point3f.y;
        this.vertexData[n4 + 2] = point3f.z;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttr(int n2, int n3, Point4f point4f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.vertexData[n4] = point4f.x;
        this.vertexData[n4 + 1] = point4f.y;
        this.vertexData[n4 + 2] = point4f.z;
        this.vertexData[n4 + 3] = point4f.w;
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttrs(int n2, int n3, float[] fArray, int n4, int n5) {
        int n6 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n7 = this.vertexAttrSizes[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        int n8 = n4 * n7;
        int n9 = n6;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n7; ++i3) {
                this.vertexData[n9 + i3] = fArray[n8 + i3];
            }
            n8 += n7;
            n9 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttrs(int n2, int n3, Point2f[] point2fArray, int n4, int n5) {
        int n6 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        int n7 = n4;
        int n8 = n6;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.vertexData[n8] = point2fArray[n7].x;
            this.vertexData[n8 + 1] = point2fArray[n7].y;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttrs(int n2, int n3, Point3f[] point3fArray, int n4, int n5) {
        int n6 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        int n7 = n4;
        int n8 = n6;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.vertexData[n8] = point3fArray[n7].x;
            this.vertexData[n8 + 1] = point3fArray[n7].y;
            this.vertexData[n8 + 2] = point3fArray[n7].z;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void setVertexAttrs(int n2, int n3, Point4f[] point4fArray, int n4, int n5) {
        int n6 = this.stride * n3 + this.vertexAttrOffsets[n2];
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        int n7 = n4;
        int n8 = n6;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.vertexData[n8] = point4fArray[n7].x;
            this.vertexData[n8 + 1] = point4fArray[n7].y;
            this.vertexData[n8 + 2] = point4fArray[n7].z;
            this.vertexData[n8 + 3] = point4fArray[n7].w;
            ++n7;
            n8 += this.stride;
        }
        if (this.source == null || !this.source.isLive()) {
            this.geomLock.unLock();
            return;
        }
        this.geomLock.unLock();
        this.sendDataChangedMessage(false);
    }

    void getCoordinate(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        fArray[2] = this.vertexData[n3 + 2];
    }

    void getCoordinate(int n2, double[] dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        dArray[0] = this.vertexData[n3];
        dArray[1] = this.vertexData[n3 + 1];
        dArray[2] = this.vertexData[n3 + 2];
    }

    void getCoordinate(int n2, Point3f point3f) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        point3f.x = this.vertexData[n3];
        point3f.y = this.vertexData[n3 + 1];
        point3f.z = this.vertexData[n3 + 2];
    }

    void getCoordinate(int n2, Point3d point3d) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        point3d.x = this.vertexData[n3];
        point3d.y = this.vertexData[n3 + 1];
        point3d.z = this.vertexData[n3 + 2];
    }

    void getCoordinates(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            fArray[n5] = this.vertexData[n6];
            fArray[n5 + 1] = this.vertexData[n6 + 1];
            fArray[n5 + 2] = this.vertexData[n6 + 2];
            n5 += 3;
            n6 += this.stride;
        }
    }

    void getCoordinates(int n2, double[] dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = dArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            dArray[n5] = this.vertexData[n6];
            dArray[n5 + 1] = this.vertexData[n6 + 1];
            dArray[n5 + 2] = this.vertexData[n6 + 2];
            n5 += 3;
            n6 += this.stride;
        }
    }

    void getCoordinates(int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = point3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point3fArray[n5].x = this.vertexData[n6];
            point3fArray[n5].y = this.vertexData[n6 + 1];
            point3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getCoordinates(int n2, Point3d[] point3dArray) {
        int n3 = this.stride * n2 + this.coordinateOffset;
        int n4 = point3dArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point3dArray[n5].x = this.vertexData[n6];
            point3dArray[n5].y = this.vertexData[n6 + 1];
            point3dArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getColor(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        fArray[2] = this.vertexData[n3 + 2];
        if ((this.vertexFormat & 8) != 0) {
            fArray[3] = this.vertexData[n3 + 3] / this.lastAlpha[0];
        }
    }

    void getColor(int n2, byte[] byArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        byArray[0] = (byte)(this.vertexData[n3] * 255.0f);
        byArray[1] = (byte)(this.vertexData[n3 + 1] * 255.0f);
        byArray[2] = (byte)(this.vertexData[n3 + 2] * 255.0f);
        if ((this.vertexFormat & 8) != 0) {
            byArray[3] = (byte)(this.vertexData[n3 + 3] / this.lastAlpha[0] * 255.0f);
        }
    }

    void getColor(int n2, Color3f color3f) {
        int n3 = this.stride * n2 + this.colorOffset;
        color3f.x = this.vertexData[n3];
        color3f.y = this.vertexData[n3 + 1];
        color3f.z = this.vertexData[n3 + 2];
    }

    void getColor(int n2, Color4f color4f) {
        int n3 = this.stride * n2 + this.colorOffset;
        color4f.x = this.vertexData[n3];
        color4f.y = this.vertexData[n3 + 1];
        color4f.z = this.vertexData[n3 + 2];
        color4f.w = this.vertexData[n3 + 3] / this.lastAlpha[0];
    }

    void getColor(int n2, Color3b color3b) {
        int n3 = this.stride * n2 + this.colorOffset;
        color3b.x = (byte)(this.vertexData[n3] * 255.0f);
        color3b.y = (byte)(this.vertexData[n3 + 1] * 255.0f);
        color3b.z = (byte)(this.vertexData[n3 + 2] * 255.0f);
    }

    void getColor(int n2, Color4b color4b) {
        int n3 = this.stride * n2 + this.colorOffset;
        color4b.x = (byte)(this.vertexData[n3] * 255.0f);
        color4b.y = (byte)(this.vertexData[n3 + 1] * 255.0f);
        color4b.z = (byte)(this.vertexData[n3 + 2] * 255.0f);
        color4b.w = (byte)(this.vertexData[n3 + 3] / this.lastAlpha[0] * 255.0f);
    }

    void getColors(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = fArray.length;
        float f2 = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                fArray[n5] = this.vertexData[n6];
                fArray[n5 + 1] = this.vertexData[n6 + 1];
                fArray[n5 + 2] = this.vertexData[n6 + 2];
                fArray[n5 + 3] = this.vertexData[n6 + 3] * f2;
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                fArray[n7] = this.vertexData[n8];
                fArray[n7 + 1] = this.vertexData[n8 + 1];
                fArray[n7 + 2] = this.vertexData[n8 + 2];
                n7 += 3;
                n8 += this.stride;
            }
        }
    }

    void getColors(int n2, byte[] byArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = byArray.length;
        float f2 = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                byArray[n5] = (byte)(this.vertexData[n6] * 255.0f);
                byArray[n5 + 1] = (byte)(this.vertexData[n6 + 1] * 255.0f);
                byArray[n5 + 2] = (byte)(this.vertexData[n6 + 2] * 255.0f);
                byArray[n5 + 3] = (byte)(this.vertexData[n6 + 3] * f2 * 255.0f);
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                byArray[n7] = (byte)(this.vertexData[n8] * 255.0f);
                byArray[n7 + 1] = (byte)(this.vertexData[n8 + 1] * 255.0f);
                byArray[n7 + 2] = (byte)(this.vertexData[n8 + 2] * 255.0f);
                n7 += 3;
                n8 += this.stride;
            }
        }
    }

    void getColors(int n2, Color3f[] color3fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            color3fArray[n5].x = this.vertexData[n6];
            color3fArray[n5].y = this.vertexData[n6 + 1];
            color3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getColors(int n2, Color4f[] color4fArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color4fArray.length;
        float f2 = 1.0f / this.lastAlpha[0];
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            color4fArray[n5].x = this.vertexData[n6];
            color4fArray[n5].y = this.vertexData[n6 + 1];
            color4fArray[n5].z = this.vertexData[n6 + 2];
            color4fArray[n5].w = this.vertexData[n6 + 3] * f2;
            ++n5;
            n6 += this.stride;
        }
    }

    void getColors(int n2, Color3b[] color3bArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color3bArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            color3bArray[n5].x = (byte)(this.vertexData[n6] * 255.0f);
            color3bArray[n5].y = (byte)(this.vertexData[n6 + 1] * 255.0f);
            color3bArray[n5].z = (byte)(this.vertexData[n6 + 2] * 255.0f);
            ++n5;
            n6 += this.stride;
        }
    }

    void getColors(int n2, Color4b[] color4bArray) {
        int n3 = this.stride * n2 + this.colorOffset;
        int n4 = color4bArray.length;
        float f2 = 1.0f / this.lastAlpha[0];
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            color4bArray[n5].x = (byte)(this.vertexData[n6] * 255.0f);
            color4bArray[n5].y = (byte)(this.vertexData[n6 + 1] * 255.0f);
            color4bArray[n5].z = (byte)(this.vertexData[n6 + 2] * 255.0f);
            color4bArray[n5].w = (byte)(this.vertexData[n6 + 3] * f2 * 255.0f);
            ++n5;
            n6 += this.stride;
        }
    }

    void getNormal(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        fArray[2] = this.vertexData[n3 + 2];
    }

    void getNormal(int n2, Vector3f vector3f) {
        int n3 = this.stride * n2 + this.normalOffset;
        vector3f.x = this.vertexData[n3];
        vector3f.y = this.vertexData[n3 + 1];
        vector3f.z = this.vertexData[n3 + 2];
    }

    void getNormals(int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        int n4 = fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            fArray[n5] = this.vertexData[n6];
            fArray[n5 + 1] = this.vertexData[n6 + 1];
            fArray[n5 + 2] = this.vertexData[n6 + 2];
            n5 += 3;
            n6 += this.stride;
        }
    }

    void getNormals(int n2, Vector3f[] vector3fArray) {
        int n3 = this.stride * n2 + this.normalOffset;
        int n4 = vector3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            vector3fArray[n5].x = this.vertexData[n6];
            vector3fArray[n5].y = this.vertexData[n6 + 1];
            vector3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinate(int n2, int n3, float[] fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        fArray[0] = this.vertexData[n4];
        fArray[1] = this.vertexData[n4 + 1];
        if ((this.vertexFormat & 0x40) != 0) {
            fArray[2] = this.vertexData[n4 + 2];
        } else if ((this.vertexFormat & 0x400) != 0) {
            fArray[2] = this.vertexData[n4 + 2];
            fArray[3] = this.vertexData[n4 + 3];
        }
    }

    void getTextureCoordinate(int n2, int n3, TexCoord2f texCoord2f) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        texCoord2f.x = this.vertexData[n4];
        texCoord2f.y = this.vertexData[n4 + 1];
    }

    void getTextureCoordinate(int n2, int n3, TexCoord3f texCoord3f) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        texCoord3f.x = this.vertexData[n4];
        texCoord3f.y = this.vertexData[n4 + 1];
        texCoord3f.z = this.vertexData[n4 + 2];
    }

    void getTextureCoordinate(int n2, int n3, TexCoord4f texCoord4f) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        texCoord4f.x = this.vertexData[n4];
        texCoord4f.y = this.vertexData[n4 + 1];
        texCoord4f.z = this.vertexData[n4 + 2];
        texCoord4f.w = this.vertexData[n4 + 3];
    }

    void getTextureCoordinates(int n2, int n3, float[] fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = fArray.length;
        if ((this.vertexFormat & 0x400) != 0) {
            int n6 = 0;
            int n7 = n4;
            while (n6 < n5) {
                fArray[n6] = this.vertexData[n7];
                fArray[n6 + 1] = this.vertexData[n7 + 1];
                fArray[n6 + 2] = this.vertexData[n7 + 2];
                fArray[n6 + 3] = this.vertexData[n7 + 3];
                n6 += 4;
                n7 += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n8 = 0;
            int n9 = n4;
            while (n8 < n5) {
                fArray[n8] = this.vertexData[n9];
                fArray[n8 + 1] = this.vertexData[n9 + 1];
                fArray[n8 + 2] = this.vertexData[n9 + 2];
                n8 += 3;
                n9 += this.stride;
            }
        } else {
            int n10 = 0;
            int n11 = n4;
            while (n10 < n5) {
                fArray[n10] = this.vertexData[n11];
                fArray[n10 + 1] = this.vertexData[n11 + 1];
                n10 += 2;
                n11 += this.stride;
            }
        }
    }

    void getTextureCoordinates(int n2, int n3, TexCoord2f[] texCoord2fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = texCoord2fArray.length;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n5) {
            texCoord2fArray[n6].x = this.vertexData[n7];
            texCoord2fArray[n6].y = this.vertexData[n7 + 1];
            ++n6;
            n7 += this.stride;
        }
    }

    void getTextureCoordinates(int n2, int n3, TexCoord3f[] texCoord3fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = texCoord3fArray.length;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n5) {
            texCoord3fArray[n6].x = this.vertexData[n7];
            texCoord3fArray[n6].y = this.vertexData[n7 + 1];
            texCoord3fArray[n6].z = this.vertexData[n7 + 2];
            ++n6;
            n7 += this.stride;
        }
    }

    void getTextureCoordinates(int n2, int n3, TexCoord4f[] texCoord4fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = texCoord4fArray.length;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n5) {
            texCoord4fArray[n6].x = this.vertexData[n7];
            texCoord4fArray[n6].y = this.vertexData[n7 + 1];
            texCoord4fArray[n6].z = this.vertexData[n7 + 2];
            texCoord4fArray[n6].w = this.vertexData[n7 + 3];
            ++n6;
            n7 += this.stride;
        }
    }

    void getTextureCoordinates(int n2, int n3, Point2f[] point2fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = point2fArray.length;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n5) {
            point2fArray[n6].x = this.vertexData[n7];
            point2fArray[n6].y = this.vertexData[n7 + 1];
            ++n6;
            n7 += this.stride;
        }
    }

    void getTextureCoordinates(int n2, int n3, Point3f[] point3fArray) {
        int n4 = this.stride * n3 + this.textureOffset + n2 * this.texCoordStride;
        int n5 = point3fArray.length;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n5) {
            point3fArray[n6].x = this.vertexData[n7];
            point3fArray[n6].y = this.vertexData[n7 + 1];
            point3fArray[n6].z = this.vertexData[n7 + 2];
            ++n6;
            n7 += this.stride;
        }
    }

    public void getVertexAttr(int n2, int n3, float[] fArray) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n5 = this.vertexAttrSizes[n2];
        for (int i2 = 0; i2 < n5; ++i2) {
            fArray[i2] = this.vertexData[n4 + i2];
        }
    }

    public void getVertexAttr(int n2, int n3, Point2f point2f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        point2f.x = this.vertexData[n4];
        point2f.y = this.vertexData[n4 + 1];
    }

    public void getVertexAttr(int n2, int n3, Point3f point3f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        point3f.x = this.vertexData[n4];
        point3f.y = this.vertexData[n4 + 1];
        point3f.z = this.vertexData[n4 + 2];
    }

    public void getVertexAttr(int n2, int n3, Point4f point4f) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        point4f.x = this.vertexData[n4];
        point4f.y = this.vertexData[n4 + 1];
        point4f.z = this.vertexData[n4 + 2];
        point4f.w = this.vertexData[n4 + 3];
    }

    public void getVertexAttrs(int n2, int n3, float[] fArray) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n5 = this.vertexAttrSizes[n2];
        int n6 = 0;
        for (int i2 = n4; n6 < fArray.length && i2 < this.vertexData.length; n6 += n5, i2 += this.stride) {
            for (int i3 = 0; i3 < n5; ++i3) {
                fArray[n6 + i3] = this.vertexData[i2 + i3];
            }
        }
    }

    public void getVertexAttrs(int n2, int n3, Point2f[] point2fArray) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n5 = 0;
        for (int i2 = n4; n5 < point2fArray.length && i2 < this.vertexData.length; ++n5, i2 += this.stride) {
            point2fArray[n5].x = this.vertexData[i2];
            point2fArray[n5].y = this.vertexData[i2 + 1];
        }
    }

    public void getVertexAttrs(int n2, int n3, Point3f[] point3fArray) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n5 = 0;
        for (int i2 = n4; n5 < point3fArray.length && i2 < this.vertexData.length; ++n5, i2 += this.stride) {
            point3fArray[n5].x = this.vertexData[i2];
            point3fArray[n5].y = this.vertexData[i2 + 1];
            point3fArray[n5].z = this.vertexData[i2 + 2];
        }
    }

    public void getVertexAttrs(int n2, int n3, Point4f[] point4fArray) {
        int n4 = this.stride * n3 + this.vertexAttrOffsets[n2];
        int n5 = 0;
        for (int i2 = n4; n5 < point4fArray.length && i2 < this.vertexData.length; ++n5, i2 += this.stride) {
            point4fArray[n5].x = this.vertexData[i2];
            point4fArray[n5].y = this.vertexData[i2 + 1];
            point4fArray[n5].z = this.vertexData[i2 + 2];
            point4fArray[n5].w = this.vertexData[i2 + 3];
        }
    }

    void updateData(GeometryUpdater geometryUpdater) {
        boolean bl = false;
        this.geomLock.getLock();
        this.inUpdater = true;
        geometryUpdater.updateData((Geometry)this.source);
        this.inUpdater = false;
        if ((this.vertexFormat & 0x80) != 0) {
            if ((this.vertexFormat & 0x800) != 0) {
                if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                    if ((this.vertexFormat & 0x100) != 0) {
                        this.setupMirrorInterleavedColorPointer(false);
                        bl = this.interleavedFloatBufferImpl == null;
                    } else {
                        this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                        bl = (this.vertexType & 0xF) == 0;
                    }
                }
            } else if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                if ((this.vertexFormat & 0x100) != 0) {
                    this.setupMirrorInterleavedColorPointer(false);
                    bl = this.interLeavedVertexData == null;
                } else {
                    this.setupMirrorVertexPointer(this.vertexType & 0xF);
                    this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                    this.setupMirrorNormalPointer(this.vertexType & 0xC00);
                    this.setupMirrorTexCoordPointer(this.texCoordType);
                    this.setupMirrorVertexAttrPointer(this.vertexAttrType);
                    boolean bl2 = bl = (this.vertexType & 0xF) == 0;
                }
            }
            if ((this.vertexFormat & 0x2000) != 0) {
                assert (this instanceof IndexedGeometryArrayRetained);
                if (((IndexedGeometryArrayRetained)this).getCoordIndicesRef() == null) {
                    bl = true;
                }
                ((IndexedGeometryArrayRetained)this).doPostUpdaterUpdate();
            }
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.geomLock.unLock();
        if (this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox, double[] dArray, Point3d point3d) {
        int n2;
        int[] nArray = new int[6];
        for (n2 = 0; n2 < 6; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            if (point3dArray[n2].x >= boundingBox.lower.x && point3dArray[n2].x <= boundingBox.upper.x && point3dArray[n2].y >= boundingBox.lower.y && point3dArray[n2].y <= boundingBox.upper.y && point3dArray[n2].z >= boundingBox.lower.z && point3dArray[n2].z <= boundingBox.upper.z) {
                return true;
            }
            if (point3dArray[n2].x < boundingBox.lower.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n2].y < boundingBox.lower.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n2].z < boundingBox.lower.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n2].x > boundingBox.upper.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n2].y > boundingBox.upper.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (!(point3dArray[n2].z > boundingBox.upper.z)) continue;
            nArray[5] = nArray[5] + 1;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (n2 = 0; n2 < 4; ++n2) {
            point3dArray2[n2] = new Point3d();
        }
        point3dArray2[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere, double[] dArray, Point3d point3d) {
        int n2;
        int n3;
        Vector3d vector3d = new Vector3d();
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            vector3d.x = point3dArray[n3].x - boundingSphere.center.x;
            vector3d.y = point3dArray[n3].y - boundingSphere.center.y;
            vector3d.z = point3dArray[n3].z - boundingSphere.center.z;
            if (!(vector3d.length() <= boundingSphere.radius)) continue;
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            boolean bl = n3 < point3dArray.length - 1 ? this.edgeIntersectSphere(boundingSphere, point3dArray[n3], point3dArray[n3 + 1]) : this.edgeIntersectSphere(boundingSphere, point3dArray[n3], point3dArray[0]);
            if (!bl) continue;
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        if (point3dArray.length < 3) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d2.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d3.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d2 = vector3d4.lengthSquared();
        if (d2 == 0.0) {
            return false;
        }
        vector3d5.x = point3dArray[0].x - boundingSphere.center.x;
        vector3d5.y = point3dArray[0].y - boundingSphere.center.y;
        vector3d5.z = point3dArray[0].z - boundingSphere.center.z;
        double d3 = vector3d4.dot(vector3d5);
        double d4 = Math.sqrt(d3 * d3 / d2);
        if (d4 > boundingSphere.radius) {
            return false;
        }
        double d5 = d3 / d2;
        point3d2.x = boundingSphere.center.x + d5 * vector3d4.x;
        point3d2.y = boundingSphere.center.y + d5 * vector3d4.y;
        point3d2.z = boundingSphere.center.z + d5 * vector3d4.z;
        if (this.pointIntersectPolygon2D(vector3d4, point3dArray, point3d2)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), vector3d4, dArray, point3d);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope, double[] dArray, Point3d point3d) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        Point4d point4d = new Point4d();
        double d2 = -1.0;
        if (point3dArray.length == 2) {
            if (boundingPolytope.intersect(point3dArray[0], point3dArray[1], point4d)) {
                if (dArray != null) {
                    point3d.x = point4d.x;
                    point3d.y = point4d.y;
                    point3d.z = point4d.z;
                    Point3d point3d2 = boundingPolytope.getCenter();
                    double d3 = point3d.x - point3d2.x;
                    double d4 = point3d.y - point3d2.y;
                    double d5 = point3d.z - point3d2.z;
                    dArray[0] = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                }
                return true;
            }
            return false;
        }
        if (bl) {
            int n6;
            System.err.println("The value of the input vertices are: ");
            for (n6 = 0; n6 < point3dArray.length; ++n6) {
                System.err.println("The " + n6 + " th vertex is: " + point3dArray[n6]);
            }
            System.err.println("The value of the input bounding Polytope's planes =");
            for (n6 = 0; n6 < boundingPolytope.planes.length; ++n6) {
                System.err.println("The " + n6 + " th plane is: " + boundingPolytope.planes[n6]);
            }
        }
        double[] dArray2 = new double[]{0.8, 0.9, 1.1, 1.2};
        boolean bl2 = true;
        boolean bl3 = false;
        if (bl3) {
            for (n5 = 0; n5 < point3dArray.length; ++n5) {
                for (n4 = 0; n4 < boundingPolytope.planes.length; ++n4) {
                    if (!(boundingPolytope.planes[n4].x * point3dArray[n5].x + boundingPolytope.planes[n4].y * point3dArray[n5].y + boundingPolytope.planes[n4].z * point3dArray[n5].z <= d2 * boundingPolytope.planes[n4].w)) {
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                if (dArray != null) {
                    this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
                }
                return true;
            }
        }
        n5 = boundingPolytope.planes.length + 2 + point3dArray.length + 1;
        n4 = 1 + point3dArray.length;
        double[][] dArray3 = new double[n4][n5];
        for (n3 = 0; n3 < boundingPolytope.planes.length; ++n3) {
            for (n2 = 0; n2 < point3dArray.length; ++n2) {
                dArray3[n2][n3] = -1.0 * (boundingPolytope.planes[n3].x * point3dArray[n2].x + boundingPolytope.planes[n3].y * point3dArray[n2].y + boundingPolytope.planes[n3].z * point3dArray[n2].z);
            }
        }
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            dArray3[n3][boundingPolytope.planes.length] = -1.0;
            dArray3[n3][boundingPolytope.planes.length + 1] = 1.0;
            for (n2 = 0; n2 < point3dArray.length; ++n2) {
                dArray3[n3][n2 + boundingPolytope.planes.length + 2] = n3 == n2 ? 1.0 : 0.0;
                dArray3[n3][n5 - 1] = dArray2[n3];
            }
        }
        for (n3 = 0; n3 < boundingPolytope.planes.length; ++n3) {
            dArray3[n4 - 1][n3] = d2 * boundingPolytope.planes[n3].w;
        }
        dArray3[n4 - 1][boundingPolytope.planes.length] = 1.0;
        dArray3[n4 - 1][boundingPolytope.planes.length + 1] = -1.0;
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            dArray3[n4 - 1][boundingPolytope.planes.length + 2 + n3] = 0.0;
        }
        if (bl) {
            System.err.println("The value of the problem tableau is: ");
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                for (n2 = 0; n2 < dArray3[0].length; ++n2) {
                    System.err.print(dArray3[n3][n2] + "  ");
                }
                System.err.println();
            }
        }
        double d6 = this.generalStandardSimplexSolver(dArray3, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.err.println("The value returned by the general standard simplex = " + d6);
        }
        if (d6 == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (dArray != null) {
            this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
        }
        return true;
    }

    double generalStandardSimplexSolver(double[][] dArray, double d2) {
        boolean bl = false;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.err.println("The number of rows is : " + n2);
            System.err.println("The number of columns is : " + n3);
        }
        while (!bl2) {
            double d3;
            int n4;
            if (bl) {
                System.err.println("input problem tableau is:");
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        System.err.println("kth, jth value is:" + i2 + " " + i3 + " : " + dArray[i2][i3]);
                    }
                }
            }
            double d4 = 0.0;
            int n5 = -1;
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                d3 = dArray[n2 - 1][n4];
                if (!(d3 < d4)) continue;
                d4 = d3;
                n5 = n4;
            }
            if (n5 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d5 = Double.POSITIVE_INFINITY;
            double d6 = 0.0;
            int n6 = -1;
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                d3 = dArray[n4][n5];
                double d7 = dArray[n4][n3 - 1];
                if (d3 == 0.0) {
                    if (!bl) continue;
                    System.err.println("Division by zero has occurred");
                    System.err.println("Within the linear program solver");
                    System.err.println("Ignoring the zero as a potential pivot");
                    continue;
                }
                if (d3 < 0.0 || d7 < 0.0) {
                    if (!bl) continue;
                    System.err.println("Ignoring cases where element is negative");
                    System.err.println("The value of element is: " + d3);
                    System.err.println("The value of end Element is: " + d7);
                    continue;
                }
                d6 = d7 / d3;
                if (bl) {
                    System.err.println("The value of element is: " + d3);
                    System.err.println("The value of endElement is: " + d7);
                    System.err.println("The value of ratio is: " + d6);
                    System.err.println("The value of prevRatio is: " + d5);
                    System.err.println("Value of ratio <= prevRatio is :" + (d6 <= d5));
                }
                if (!(d6 <= d5)) continue;
                if (bl) {
                    System.err.println("updating prevRatio with ratio");
                }
                d5 = d6;
                n6 = n4;
            }
            if (n6 == -1) {
                if (bl) {
                    System.err.println("UNABLE TO FIND SOLUTION");
                    System.err.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d8 = dArray[n6][n5];
            if (bl) {
                System.err.println("The value of row index is: " + n6);
                System.err.println("The value of col index is: " + n5);
                System.err.println("The value of pivotValue is: " + d8);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                dArray[n6][n4] = dArray[n6][n4] / d8;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (n4 == n6) continue;
                double d9 = dArray[n4][n5];
                for (int i4 = 0; i4 < n3; ++i4) {
                    dArray[n4][i4] = dArray[n4][i4] - d9 * dArray[n6][i4];
                }
            }
        }
        return dArray[n2 - 1][n3 - 1];
    }

    boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = boundingSphere.center.x - point3d.x;
        vector3d2.y = boundingSphere.center.y - point3d.y;
        vector3d2.z = boundingSphere.center.z - point3d.z;
        double d2 = vector3d.dot(vector3d2);
        if (d2 < 0.0) {
            return false;
        }
        double d3 = vector3d.lengthSquared();
        double d4 = d2 * d2 / d3;
        if (d4 < d3) {
            return false;
        }
        double d5 = boundingSphere.radius * boundingSphere.radius;
        double d6 = vector3d2.lengthSquared();
        return d6 - d4 <= d5;
    }

    double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d2 = Math.abs(vector3d.x);
        double d3 = Math.abs(vector3d.y);
        double d4 = Math.abs(vector3d.z);
        int n2 = d2 > d3 ? 0 : 1;
        if (n2 == 0) {
            if (d2 < d4) {
                n2 = 2;
            }
        } else if (n2 == 1 && d3 < d4) {
            n2 = 2;
        }
        block10: for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            point2dArray[i2] = new Point2d();
            switch (n2) {
                case 0: {
                    point2dArray[i2].x = point3dArray[i2].y;
                    point2dArray[i2].y = point3dArray[i2].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[i2].x = point3dArray[i2].x;
                    point2dArray[i2].y = point3dArray[i2].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[i2].x = point3dArray[i2].x;
                    point2dArray[i2].y = point3dArray[i2].y;
                }
            }
        }
        switch (n2) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
            }
        }
        for (int i3 = 0; i3 < point3dArray.length; ++i3) {
            if (i3 < point3dArray.length - 1) {
                if (this.det2D(point2dArray[i3], point2dArray[i3 + 1], point2d) > 0.0) continue;
                return false;
            }
            if (this.det2D(point2dArray[i3], point2dArray[0], point2d) > 0.0) continue;
            return false;
        }
        return true;
    }

    boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.set(point3d);
        double d2 = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d3 = vector3d.dot(vector3d3);
        if (d3 == 0.0) {
            return false;
        }
        vector3d2.set(point3d2);
        double d4 = (d2 - vector3d.dot(vector3d2)) / d3;
        if (d4 < 0.0 || d4 > 1.0) {
            return false;
        }
        point3d4.x = point3d2.x + d4 * vector3d3.x;
        point3d4.y = point3d2.y + d4 * vector3d3.y;
        point3d4.z = point3d2.z + d4 * vector3d3.z;
        return true;
    }

    boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        int n2;
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d2 = Math.abs(vector3d.x);
        double d3 = Math.abs(vector3d.y);
        double d4 = Math.abs(vector3d.z);
        int n3 = d2 > d3 ? 0 : 1;
        if (n3 == 0) {
            if (d2 < d4) {
                n3 = 2;
            }
        } else if (n3 == 1 && d3 < d4) {
            n3 = 2;
        }
        block10: for (n2 = 0; n2 < point3dArray.length; ++n2) {
            point2dArray[n2] = new Point2d();
            switch (n3) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                }
            }
        }
        block11: for (n2 = 0; n2 < 2; ++n2) {
            point2dArray2[n2] = new Point2d();
            switch (n3) {
                case 0: {
                    point2dArray2[n2].x = point3dArray2[n2].y;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    continue block11;
                }
                case 1: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    continue block11;
                }
                case 2: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].y;
                }
            }
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            for (n2 = 0; n2 < 2; ++n2) {
                blArray[n2][i2] = i2 < point3dArray.length - 1 ? this.det2D(point2dArray[i2], point2dArray[i2 + 1], point2dArray2[n2]) < 0.0 : this.det2D(point2dArray[i2], point2dArray[0], point2dArray2[n2]) < 0.0;
            }
            if (blArray[0][i2] || blArray[1][i2]) continue;
            return false;
        }
        boolean bl = true;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            if (blArray[0][n2]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            if (blArray[1][n2]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        int n4 = 0;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            if (!(this.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n2]) < 0.0)) continue;
            ++n4;
        }
        return n4 != 0 && n4 != point3dArray.length;
    }

    double getCompValue(Point3d point3d, int n2) {
        switch (n2) {
            case 0: {
                return point3d.x;
            }
            case 1: {
                return point3d.y;
            }
        }
        return point3d.z;
    }

    double getCompValue(Point3d point3d, Point3d point3d2, int n2) {
        switch (n2) {
            case 0: {
                return point3d.x - point3d2.x;
            }
            case 1: {
                return point3d.y - point3d2.y;
            }
        }
        return point3d.z - point3d2.z;
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Vector3d vector3d) {
        int n2;
        int n3;
        double d2 = Math.abs(vector3d.x);
        double d3 = Math.abs(vector3d.y);
        double d4 = Math.abs(vector3d.z);
        if (d2 > d3) {
            if (d2 > d4) {
                n3 = 1;
                n2 = 2;
            } else {
                n3 = 0;
                n2 = 1;
            }
        } else if (d4 > d3) {
            n3 = 0;
            n2 = 1;
        } else {
            n3 = 0;
            n2 = 2;
        }
        return this.pointInTri(point3d, point3d2, point3d3, point3d4, n3, n2);
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, int n2, int n3) {
        double d2 = this.getCompValue(point3d3, point3d2, n3);
        double d3 = -this.getCompValue(point3d3, point3d2, n2);
        double d4 = -d2 * this.getCompValue(point3d2, n2) - d3 * this.getCompValue(point3d2, n3);
        double d5 = d2 * this.getCompValue(point3d, n2) + d3 * this.getCompValue(point3d, n3) + d4;
        d2 = this.getCompValue(point3d4, point3d3, n3);
        d3 = -this.getCompValue(point3d4, point3d3, n2);
        d4 = -d2 * this.getCompValue(point3d3, n2) - d3 * this.getCompValue(point3d3, n3);
        double d6 = d2 * this.getCompValue(point3d, n2) + d3 * this.getCompValue(point3d, n3) + d4;
        d2 = this.getCompValue(point3d2, point3d4, n3);
        d3 = -this.getCompValue(point3d2, point3d4, n2);
        d4 = -d2 * this.getCompValue(point3d4, n2) - d3 * this.getCompValue(point3d4, n3);
        double d7 = d2 * this.getCompValue(point3d, n2) + d3 * this.getCompValue(point3d, n3) + d4;
        return d5 * d6 > 0.0 && d5 * d7 > 0.0;
    }

    boolean edgeAgainstEdge(Point3d point3d, Point3d point3d2, Point3d point3d3, double d2, double d3, int n2, int n3) {
        double d4 = this.getCompValue(point3d2, point3d3, n2);
        double d5 = this.getCompValue(point3d2, point3d3, n3);
        double d6 = this.getCompValue(point3d, point3d2, n2);
        double d7 = this.getCompValue(point3d, point3d2, n3);
        double d8 = d3 * d4 - d2 * d5;
        double d9 = d5 * d6 - d4 * d7;
        if (d8 > 0.0 && d9 >= 0.0 && d9 <= d8 || d8 < 0.0 && d9 <= 0.0 && d9 >= d8) {
            double d10 = d2 * d7 - d3 * d6;
            if (d8 > 0.0 ? d10 >= 0.0 && d10 <= d8 : d10 <= 0.0 && d10 >= d8) {
                return true;
            }
        }
        return false;
    }

    boolean edgeAgainstTriEdges(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, int n2, int n3) {
        double d2;
        double d3 = this.getCompValue(point3d2, point3d, n2);
        if (this.edgeAgainstEdge(point3d, point3d3, point3d4, d3, d2 = this.getCompValue(point3d2, point3d, n3), n2, n3)) {
            return true;
        }
        if (this.edgeAgainstEdge(point3d, point3d4, point3d5, d3, d2, n2, n3)) {
            return true;
        }
        return this.edgeAgainstEdge(point3d, point3d5, point3d3, d3, d2, n2, n3);
    }

    boolean coplanarTriTri(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        int n2;
        int n3;
        double d2 = Math.abs(vector3d.x);
        double d3 = Math.abs(vector3d.y);
        double d4 = Math.abs(vector3d.z);
        if (d2 > d3) {
            if (d2 > d4) {
                n3 = 1;
                n2 = 2;
            } else {
                n3 = 0;
                n2 = 1;
            }
        } else if (d4 > d3) {
            n3 = 0;
            n2 = 1;
        } else {
            n3 = 0;
            n2 = 2;
        }
        if (this.edgeAgainstTriEdges(point3d, point3d2, point3d4, point3d5, point3d6, n3, n2)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d2, point3d3, point3d4, point3d5, point3d6, n3, n2)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d3, point3d, point3d4, point3d5, point3d6, n3, n2)) {
            return true;
        }
        if (this.pointInTri(point3d, point3d4, point3d5, point3d6, n3, n2)) {
            return true;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n3, n2);
    }

    boolean intersectTriPnt(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        int n2;
        int n3;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set(point3d);
        double d2 = -vector3d3.dot(vector3d4);
        vector3d4.set(point3d4);
        double d3 = vector3d3.dot(vector3d4) + d2;
        if (Math.abs(d3) < 1.0E-13) {
            d3 = 0.0;
        }
        if (d3 != 0.0) {
            return false;
        }
        double d4 = Math.abs(vector3d3.x);
        double d5 = Math.abs(vector3d3.y);
        double d6 = Math.abs(vector3d3.z);
        if (d4 > d5) {
            if (d4 > d6) {
                n3 = 1;
                n2 = 2;
            } else {
                n3 = 0;
                n2 = 1;
            }
        } else if (d6 > d5) {
            n3 = 0;
            n2 = 1;
        } else {
            n3 = 0;
            n2 = 2;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n3, n2);
    }

    boolean intersectTriTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d5.set(point3d);
        double d8 = -vector3d3.dot(vector3d5);
        vector3d5.set(point3d4);
        double d9 = vector3d3.dot(vector3d5) + d8;
        vector3d5.set(point3d5);
        double d10 = vector3d3.dot(vector3d5) + d8;
        vector3d5.set(point3d6);
        double d11 = vector3d3.dot(vector3d5) + d8;
        if (Math.abs(d9) < 1.0E-13) {
            d9 = 0.0;
        }
        if (Math.abs(d10) < 1.0E-13) {
            d10 = 0.0;
        }
        if (Math.abs(d11) < 1.0E-13) {
            d11 = 0.0;
        }
        double d12 = d9 * d10;
        double d13 = d9 * d11;
        if (d12 > 0.0 && d13 > 0.0) {
            return false;
        }
        vector3d.x = point3d5.x - point3d4.x;
        vector3d.y = point3d5.y - point3d4.y;
        vector3d.z = point3d5.z - point3d4.z;
        vector3d2.x = point3d6.x - point3d4.x;
        vector3d2.y = point3d6.y - point3d4.y;
        vector3d2.z = point3d6.z - point3d4.z;
        vector3d4.cross(vector3d, vector3d2);
        if (vector3d4.length() == 0.0) {
            return false;
        }
        vector3d5.set(point3d4);
        double d14 = -vector3d4.dot(vector3d5);
        vector3d5.set(point3d);
        double d15 = vector3d4.dot(vector3d5) + d14;
        vector3d5.set(point3d2);
        double d16 = vector3d4.dot(vector3d5) + d14;
        vector3d5.set(point3d3);
        double d17 = vector3d4.dot(vector3d5) + d14;
        if (Math.abs(d15) < 1.0E-13) {
            d15 = 0.0;
        }
        if (Math.abs(d16) < 1.0E-13) {
            d16 = 0.0;
        }
        if (Math.abs(d17) < 1.0E-13) {
            d17 = 0.0;
        }
        double d18 = d15 * d16;
        double d19 = d15 * d17;
        if (d18 > 0.0 && d19 > 0.0) {
            return false;
        }
        vector3d5.cross(vector3d3, vector3d4);
        double d20 = Math.abs(vector3d5.x);
        int n2 = 0;
        double d21 = Math.abs(vector3d5.y);
        double d22 = Math.abs(vector3d5.z);
        if (d21 > d20) {
            d20 = d21;
            n2 = 1;
        }
        if (d22 > d20) {
            d20 = d22;
            n2 = 2;
        }
        switch (n2) {
            case 0: {
                d2 = point3d.x;
                d3 = point3d2.x;
                d4 = point3d3.x;
                d5 = point3d4.x;
                d6 = point3d5.x;
                d7 = point3d6.x;
                break;
            }
            case 1: {
                d2 = point3d.y;
                d3 = point3d2.y;
                d4 = point3d3.y;
                d5 = point3d4.y;
                d6 = point3d5.y;
                d7 = point3d6.y;
                break;
            }
            case 2: {
                d2 = point3d.z;
                d3 = point3d2.z;
                d4 = point3d3.z;
                d5 = point3d4.z;
                d6 = point3d5.z;
                d7 = point3d6.z;
            }
        }
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        double d27 = 0.0;
        if (d18 > 0.0) {
            d23 = d4;
            d24 = (d2 - d4) * d17;
            d25 = (d3 - d4) * d17;
            d26 = d17 - d15;
            d27 = d17 - d16;
        } else if (d19 > 0.0) {
            d23 = d3;
            d24 = (d2 - d3) * d16;
            d25 = (d4 - d3) * d16;
            d26 = d16 - d15;
            d27 = d16 - d17;
        } else if (d16 * d17 > 0.0 || d15 != 0.0) {
            d23 = d2;
            d24 = (d3 - d2) * d15;
            d25 = (d4 - d2) * d15;
            d26 = d15 - d16;
            d27 = d15 - d17;
        } else if (d16 != 0.0) {
            d23 = d3;
            d24 = (d2 - d3) * d16;
            d25 = (d4 - d3) * d16;
            d26 = d16 - d15;
            d27 = d16 - d17;
        } else if (d17 != 0.0) {
            d23 = d4;
            d24 = (d2 - d4) * d17;
            d25 = (d3 - d4) * d17;
            d26 = d17 - d15;
            d27 = d17 - d16;
        } else {
            boolean bl = this.coplanarTriTri(vector3d3, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            return bl;
        }
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        double d32 = 0.0;
        if (d12 > 0.0) {
            d28 = d7;
            d29 = (d5 - d7) * d11;
            d30 = (d6 - d7) * d11;
            d31 = d11 - d9;
            d32 = d11 - d10;
        } else if (d13 > 0.0) {
            d28 = d6;
            d29 = (d5 - d6) * d10;
            d30 = (d7 - d6) * d10;
            d31 = d10 - d9;
            d32 = d10 - d11;
        } else if (d10 * d11 > 0.0 || d9 != 0.0) {
            d28 = d5;
            d29 = (d6 - d5) * d9;
            d30 = (d7 - d5) * d9;
            d31 = d9 - d10;
            d32 = d9 - d11;
        } else if (d10 != 0.0) {
            d28 = d6;
            d29 = (d5 - d6) * d10;
            d30 = (d7 - d6) * d10;
            d31 = d10 - d9;
            d32 = d10 - d11;
        } else if (d11 != 0.0) {
            d28 = d7;
            d29 = (d5 - d7) * d11;
            d30 = (d6 - d7) * d11;
            d31 = d11 - d9;
            d32 = d11 - d10;
        } else {
            boolean bl = this.coplanarTriTri(vector3d4, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            return bl;
        }
        double d33 = d26 * d27;
        double d34 = d31 * d32;
        double d35 = d33 * d34;
        double d36 = d23 * d35;
        double d37 = d36 + d24 * d27 * d34;
        double d38 = d36 + d25 * d26 * d34;
        d36 = d28 * d35;
        double d39 = d36 + d29 * d32 * d33;
        double d40 = d36 + d30 * d31 * d33;
        if (d37 > d38) {
            d36 = d37;
            d37 = d38;
            d38 = d36;
        }
        if (d39 > d40) {
            d36 = d39;
            d39 = d40;
            d40 = d36;
        }
        return !(d38 < d39) && !(d40 < d37);
    }

    boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2) {
        boolean bl;
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        n2 = 0;
        Point3d[] point3dArray3 = new Point3d[]{new Point3d(), new Point3d()};
        for (n3 = 0; !(n3 >= point3dArray2.length || (bl = n3 < point3dArray2.length - 1 ? this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n3], point3dArray2[n3 + 1], point3dArray3[n2]) : this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n3], point3dArray2[0], point3dArray3[n2])) && ++n2 > 1); ++n3) {
        }
        if (n2 == 0) {
            return false;
        }
        if (point3dArray2.length < 3) {
            boolean bl2 = this.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
            return bl2;
        }
        boolean bl3 = this.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
        return bl3;
    }

    boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, double[] dArray, Point3d point3d) {
        return this.intersectRayOrSegment(point3dArray, pickRay.direction, pickRay.origin, dArray, point3d, false);
    }

    boolean intersectSegment(Point3d[] point3dArray, Point3d point3d, Point3d point3d2, double[] dArray, Point3d point3d3) {
        Vector3d vector3d = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        boolean bl = this.intersectRayOrSegment(point3dArray, vector3d, point3d, dArray, point3d3, true);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean intersectRayOrSegment(Point3d[] point3dArray, Vector3d vector3d, Point3d point3d, double[] dArray, Point3d point3d2, boolean bl) {
        int n2;
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            n4 = n2 != point3dArray.length - 1 ? n2 + 1 : 0;
            vector3d2.x = point3dArray[n4].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n4].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n4].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        for (int i2 = n4; i2 < point3dArray.length; ++i2) {
            n3 = i2 != point3dArray.length - 1 ? i2 + 1 : 0;
            vector3d3.x = point3dArray[n3].x - point3dArray[i2].x;
            vector3d3.y = point3dArray[n3].y - point3dArray[i2].y;
            vector3d3.z = point3dArray[n3].z - point3dArray[i2].z;
            if (vector3d3.length() > 0.0) break;
        }
        vector3d4.cross(vector3d2, vector3d3);
        if (vector3d3.length() == 0.0 || vector3d4.length() == 0.0) {
            n3 = n4 == 0 ? point3dArray.length - 1 : n4 - 1;
            return this.intersectLineAndRay(point3dArray[n4], point3dArray[n3], point3d, vector3d, dArray, point3d2);
        }
        d3 = vector3d4.dot(vector3d);
        if (d3 == 0.0) {
            n2 = 0;
            while (n2 < point3dArray.length) {
                n3 = n2 != point3dArray.length - 1 ? n2 + 1 : 0;
                if (this.intersectLineAndRay(point3dArray[n2], point3dArray[n3], point3d, vector3d, dArray, point3d2)) {
                    return true;
                }
                ++n2;
            }
            return bl2;
        }
        Vector3d vector3d5 = new Vector3d();
        vector3d5.set(point3dArray[0]);
        d2 = vector3d4.dot(vector3d5);
        vector3d5.set(point3d);
        dArray[0] = (d2 - vector3d4.dot(vector3d5)) / d3;
        if (dArray[0] < -1.0E-13) return false;
        if (bl && dArray[0] > 1.0000000000001) {
            return false;
        }
        if (point3d2 == null) {
            point3d2 = new Point3d();
        }
        point3d2.x = point3d.x + vector3d.x * dArray[0];
        point3d2.y = point3d.y + vector3d.y * dArray[0];
        point3d2.z = point3d.z + vector3d.z * dArray[0];
        double d4 = Math.abs(vector3d4.x);
        double d5 = Math.abs(vector3d4.y);
        double d6 = Math.abs(vector3d4.z);
        double d7 = 0.0;
        Point3d point3d3 = point3dArray[point3dArray.length - 1];
        Point3d point3d4 = point3dArray[0];
        bl2 = true;
        if (d4 > d5) {
            if (d4 < d6) {
                for (n2 = 0; n2 < point3dArray.length; ++n2) {
                    point3d3 = point3dArray[n2];
                    point3d4 = n2 != point3dArray.length - 1 ? point3dArray[n2 + 1] : point3dArray[0];
                    double d8 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d8)) {
                        if (d8 * d7 < 0.0) {
                            return false;
                        }
                        d7 = d8;
                        continue;
                    }
                    double d9 = point3d4.y - point3d3.y;
                    if (GeometryArrayRetained.isNonZero(d9)) {
                        if (!((d9 = (point3d2.y - point3d3.y) / d9) > -1.0E-13)) return false;
                        if (!(d9 < 1.0000000000001)) return false;
                        boolean bl3 = true;
                        bl2 = bl3;
                    } else {
                        d9 = point3d4.x - point3d3.x;
                        if (!GeometryArrayRetained.isNonZero(d9)) continue;
                        if (!((d9 = (point3d2.x - point3d3.x) / d9) > -1.0E-13)) return false;
                        if (!(d9 < 1.0000000000001)) return false;
                        boolean bl4 = true;
                        bl2 = bl4;
                    }
                    break;
                }
            } else {
                for (n2 = 0; n2 < point3dArray.length; ++n2) {
                    point3d3 = point3dArray[n2];
                    point3d4 = n2 != point3dArray.length - 1 ? point3dArray[n2 + 1] : point3dArray[0];
                    double d10 = (point3d2.y - point3d3.y) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d10)) {
                        if (d10 * d7 < 0.0) {
                            return false;
                        }
                        d7 = d10;
                        continue;
                    }
                    double d11 = point3d4.y - point3d3.y;
                    if (GeometryArrayRetained.isNonZero(d11)) {
                        if (!((d11 = (point3d2.y - point3d3.y) / d11) > -1.0E-13)) return false;
                        if (!(d11 < 1.0000000000001)) return false;
                        boolean bl5 = true;
                        bl2 = bl5;
                    } else {
                        d11 = point3d4.z - point3d3.z;
                        if (!GeometryArrayRetained.isNonZero(d11)) continue;
                        if (!((d11 = (point3d2.z - point3d3.z) / d11) > -1.0E-13)) return false;
                        if (!(d11 < 1.0000000000001)) return false;
                        boolean bl6 = true;
                        bl2 = bl6;
                    }
                    break;
                }
            }
        } else if (d5 < d6) {
            for (n2 = 0; n2 < point3dArray.length; ++n2) {
                point3d3 = point3dArray[n2];
                point3d4 = n2 != point3dArray.length - 1 ? point3dArray[n2 + 1] : point3dArray[0];
                double d12 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                if (GeometryArrayRetained.isNonZero(d12)) {
                    if (d12 * d7 < 0.0) {
                        return false;
                    }
                    d7 = d12;
                    continue;
                }
                double d13 = point3d4.y - point3d3.y;
                if (GeometryArrayRetained.isNonZero(d13)) {
                    if (!((d13 = (point3d2.y - point3d3.y) / d13) > -1.0E-13)) return false;
                    if (!(d13 < 1.0000000000001)) return false;
                    boolean bl7 = true;
                    bl2 = bl7;
                } else {
                    d13 = point3d4.x - point3d3.x;
                    if (!GeometryArrayRetained.isNonZero(d13)) continue;
                    if (!((d13 = (point3d2.x - point3d3.x) / d13) > -1.0E-13)) return false;
                    if (!(d13 < 1.0000000000001)) return false;
                    boolean bl8 = true;
                    bl2 = bl8;
                }
                break;
            }
        } else {
            for (n2 = 0; n2 < point3dArray.length; ++n2) {
                point3d3 = point3dArray[n2];
                point3d4 = n2 != point3dArray.length - 1 ? point3dArray[n2 + 1] : point3dArray[0];
                double d14 = (point3d2.x - point3d3.x) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.x - point3d3.x);
                if (GeometryArrayRetained.isNonZero(d14)) {
                    if (d14 * d7 < 0.0) {
                        return false;
                    }
                    d7 = d14;
                    continue;
                }
                double d15 = point3d4.x - point3d3.x;
                if (GeometryArrayRetained.isNonZero(d15)) {
                    if (!((d15 = (point3d2.x - point3d3.x) / d15) > -1.0E-13)) return false;
                    if (!(d15 < 1.0000000000001)) return false;
                    boolean bl9 = true;
                    bl2 = bl9;
                } else {
                    d15 = point3d4.z - point3d3.z;
                    if (!GeometryArrayRetained.isNonZero(d15)) continue;
                    if (!((d15 = (point3d2.z - point3d3.z) / d15) > -1.0E-13)) return false;
                    if (!(d15 < 1.0000000000001)) return false;
                    boolean bl10 = true;
                    bl2 = bl10;
                }
                break;
            }
        }
        if (!bl2) return bl2;
        dArray[0] = dArray[0] * vector3d.length();
        return bl2;
    }

    static final boolean isNonZero(double d2) {
        return d2 > 1.0E-13 || d2 < -1.0E-13;
    }

    boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n2) {
        int n3;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d2 = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n4 + 1].x - point3dArray[n4].x;
            vector3d.y = point3dArray[n4 + 1].y - point3dArray[n4].y;
            vector3d.z = point3dArray[n4 + 1].z - point3dArray[n4++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n3 = n4; n3 < point3dArray.length - 1; ++n3) {
            vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n3 == point3dArray.length - 1) {
            return false;
        }
        if (n2 == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set(point3dArray[0]);
        d2 = vector3d3.dot(vector3d4);
        vector3d4.set(pickPoint.location);
        return d2 - vector3d3.dot(vector3d4) <= 0.0;
    }

    boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z;
    }

    boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d2;
        int n2 = 0;
        if (vector3d.x != 0.0) {
            n2 = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n2 = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n2 = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n2 == 0 && (point3d.y < (d2 = point3d2.y + dArray[0] * vector3d.y) - 1.0E-13 || point3d.y > d2 + 1.0E-13)) {
            return false;
        }
        return n2 >= 2 || !(point3d.z < (d2 = point3d2.z + dArray[0] * vector3d.z) - 1.0E-13) && !(point3d.z > d2 + 1.0E-13);
    }

    boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d2 = vector3d2.x;
        double d3 = -vector3d.y;
        double d4 = vector3d2.y;
        double d5 = -vector3d.x;
        double d6 = d2 * d3 - d4 * d5;
        if (d6 == 0.0) {
            boolean bl = false;
            if (vector3d2.x == 0.0 && vector3d2.y == 0.0 && vector3d2.z == 0.0 && (bl = this.intersectPntAndRay(point3d, point3d3, vector3d, dArray)) && point3d4 != null) {
                point3d4.set(point3d);
            }
            return bl;
        }
        double d7 = 1.0 / d6;
        double d8 = d7 * d3;
        double d9 = d7 * -d5;
        double d10 = d7 * -d4;
        double d11 = d7 * d2;
        d7 = point3d3.x - point3d.x;
        double d12 = point3d3.y - point3d.y;
        double d13 = d8 * d7 + d9 * d12;
        double d14 = d10 * d7 + d11 * d12;
        if (d14 < 0.0) {
            return false;
        }
        if (d13 < 0.0 || d13 > 1.0) {
            return false;
        }
        d7 = point3d3.z + d14 * vector3d.z;
        d12 = point3d.z + d13 * vector3d2.z;
        if (d7 < d12 - 1.0E-13 || d7 > d12 + 1.0E-13) {
            return false;
        }
        dArray[0] = d14;
        if (point3d4 != null) {
            point3d4.x = point3d3.x + vector3d.x * dArray[0];
            point3d4.y = point3d3.y + vector3d.y * dArray[0];
            point3d4.z = point3d3.z + vector3d.z * dArray[0];
        }
        return true;
    }

    boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, double[] dArray, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
        }
        if (point3dArray.length > 2 && (pickCylinder instanceof PickCylinderRay ? this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d) : this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d))) {
            return true;
        }
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            int n2 = i2 < point3dArray.length - 1 ? i2 + 1 : 0;
            double d3 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment(point3d2, point3d3, point3dArray[i2], point3dArray[n2], point3d4, point3d, null) : Distance.rayToSegment(point3d2, vector3d, point3dArray[i2], point3dArray[n2], point3d4, point3d, null);
            if (!(d3 <= d2 * d2)) continue;
            vector3d2.sub(point3d4, point3d2);
            dArray[0] = vector3d2.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, double[] dArray, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d3 = new Vector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
        }
        if (point3dArray.length > 2 && (pickCone instanceof PickConeRay ? this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d) : this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d))) {
            return true;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            n2 = i2 < point3dArray.length - 1 ? i2 + 1 : 0;
            double d2 = pickCone instanceof PickConeSegment ? Distance.segmentToSegment(point3d2, point3d3, point3dArray[i2], point3dArray[n2], point3d4, point3d, null) : Distance.rayToSegment(point3d2, vector3d, point3dArray[i2], point3dArray[n2], point3d4, point3d, null);
            vector3d2.sub(point3d4, point3d2);
            double d3 = vector3d2.length();
            double d4 = Math.tan(pickCone.getSpreadAngle()) * d3;
            if (!(d2 <= d4 * d4)) continue;
            dArray[0] = d3;
            return true;
        }
        return false;
    }

    boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, double[] dArray) {
        double d2;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d3 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d2 = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d2 = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        if (d2 <= d3 * d3) {
            vector3d2.sub(point3d4, point3d2);
            dArray[0] = vector3d2.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d point3d, PickCone pickCone, double[] dArray) {
        double d2;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (point3d4 == null) {
            point3d4 = new Point3d();
        }
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d2 = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d2 = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        vector3d2.sub(point3d4, point3d2);
        double d3 = vector3d2.length();
        double d4 = Math.tan(pickCone.getSpreadAngle()) * d3;
        if (d2 <= d4 * d4) {
            dArray[0] = d3;
            return true;
        }
        return false;
    }

    void setCoordRefBuffer(J3DBuffer j3DBuffer) {
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    assert (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 8: {
                    assert (((DoubleBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.coordRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefCoords = null;
            this.doubleBufferRefCoords = null;
            this.vertexType &= 0xFFFFFFFD;
            this.vertexType &= 0xFFFFFFFE;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefCoords = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.doubleBufferRefCoords = null;
                    this.vertexType |= 1;
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                case 8: {
                    this.floatBufferRefCoords = null;
                    this.doubleBufferRefCoords = (DoubleBufferWrapper)j3DBuffer.getBufferImpl();
                    this.vertexType |= 2;
                    this.vertexType &= 0xFFFFFFFE;
                    break;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(j3DBuffer == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    J3DBuffer getCoordRefBuffer() {
        return this.coordRefBuffer;
    }

    void setCoordRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 1) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (fArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.floatRefCoords = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFFE) : (this.vertexType |= 1);
        } else {
            this.setupMirrorVertexPointer(1);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    float[] getCoordRefFloat() {
        return this.floatRefCoords;
    }

    void setCoordRefDouble(double[] dArray) {
        if (dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 2) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (dArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.doubleRefCoords = dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = dArray == null ? (this.vertexType &= 0xFFFFFFFD) : (this.vertexType |= 2);
        } else {
            this.setupMirrorVertexPointer(2);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    double[] getCoordRefDouble() {
        return this.doubleRefCoords;
    }

    void setCoordRef3f(Point3f[] point3fArray) {
        if (point3fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 4) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3fArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.p3fRefCoords = point3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3fArray == null ? (this.vertexType &= 0xFFFFFFFB) : (this.vertexType |= 4);
        } else {
            this.setupMirrorVertexPointer(4);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(point3fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3f[] getCoordRef3f() {
        return this.p3fRefCoords;
    }

    void setCoordRef3d(Point3d[] point3dArray) {
        if (point3dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 8) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3dArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.p3dRefCoords = point3dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3dArray == null ? (this.vertexType &= 0xFFFFFFF7) : (this.vertexType |= 8);
        } else {
            this.setupMirrorVertexPointer(8);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null) {
            if (this.source.isLive()) {
                this.processCoordsChanged(point3dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3d[] getCoordRef3d() {
        return this.p3dRefCoords;
    }

    void setColorRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 16) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (fArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.floatRefColors = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFEF) : (this.vertexType |= 0x10);
        } else {
            this.setupMirrorColorPointer(16, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getColorRefFloat() {
        return this.floatRefColors;
    }

    void setColorRefBuffer(J3DBuffer j3DBuffer) {
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    assert (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 2: {
                    assert (((ByteBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.colorRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefColors = null;
            this.byteBufferRefColors = null;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefColors = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.byteBufferRefColors = null;
                    break;
                }
                case 2: {
                    this.byteBufferRefColors = (ByteBufferWrapper)j3DBuffer.getBufferImpl();
                    this.floatBufferRefColors = null;
                    break;
                }
            }
        }
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            if (j3DBuffer == null) {
                this.vertexType &= 0xFFFFFFEF;
                this.vertexType &= 0xFFFFFFDF;
            } else {
                switch (j3DBuffer.getBufferType()) {
                    case 7: {
                        this.vertexType |= 0x10;
                        this.vertexType &= 0xFFFFFFDF;
                        break;
                    }
                    case 2: {
                        this.vertexType |= 0x20;
                        this.vertexType &= 0xFFFFFFEF;
                        break;
                    }
                }
            }
        } else {
            this.setupMirrorColorPointer(48, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getColorRefBuffer() {
        return this.colorRefBuffer;
    }

    void setColorRefByte(byte[] byArray) {
        if (byArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 32) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (byArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.byteRefColors = byArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = byArray == null ? (this.vertexType &= 0xFFFFFFDF) : (this.vertexType |= 0x20);
        } else {
            this.setupMirrorColorPointer(32, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    byte[] getColorRefByte() {
        return this.byteRefColors;
    }

    void setColorRef3f(Color3f[] color3fArray) {
        if (color3fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 64) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3fRefColors = color3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3fArray == null ? (this.vertexType &= 0xFFFFFFBF) : (this.vertexType |= 0x40);
        } else {
            this.setupMirrorColorPointer(64, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3f[] getColorRef3f() {
        return this.c3fRefColors;
    }

    void setColorRef4f(Color4f[] color4fArray) {
        if (color4fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 128) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4fRefColors = color4fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4fArray == null ? (this.vertexType &= 0xFFFFFF7F) : (this.vertexType |= 0x80);
        } else {
            this.setupMirrorColorPointer(128, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4f[] getColorRef4f() {
        return this.c4fRefColors;
    }

    void setColorRef3b(Color3b[] color3bArray) {
        if (color3bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 256) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3bRefColors = color3bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3bArray == null ? (this.vertexType &= 0xFFFFFEFF) : (this.vertexType |= 0x100);
        } else {
            this.setupMirrorColorPointer(256, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3b[] getColorRef3b() {
        return this.c3bRefColors;
    }

    void setColorRef4b(Color4b[] color4bArray) {
        if (color4bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 512) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4bRefColors = color4bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4bArray == null ? (this.vertexType &= 0xFFFFFDFF) : (this.vertexType |= 0x200);
        } else {
            this.setupMirrorColorPointer(512, false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4b[] getColorRef4b() {
        return this.c4bRefColors;
    }

    void setNormalRefFloat(float[] fArray) {
        if (fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 1024) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.floatRefNormals = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFBFF) : (this.vertexType |= 0x400);
        } else {
            this.setupMirrorNormalPointer(1024);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getNormalRefFloat() {
        return this.floatRefNormals;
    }

    void setNormalRefBuffer(J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            assert (floatBufferWrapper.isDirect());
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= ((FloatBufferWrapper)j3DBuffer.getBufferImpl()).limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (floatBufferWrapper.limit() < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.normalRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.vertexType &= 0xFFFFFBFF;
            this.floatBufferRefNormals = null;
        } else {
            this.vertexType |= 0x400;
            this.floatBufferRefNormals = floatBufferWrapper;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getNormalRefBuffer() {
        return this.normalRefBuffer;
    }

    void setNormalRef3f(Vector3f[] vector3fArray) {
        if (vector3fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 2048) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex >= vector3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (vector3fArray.length < this.initialNormalIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.v3fRefNormals = vector3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = vector3fArray == null ? (this.vertexType &= 0xFFFFF7FF) : (this.vertexType |= 0x800);
        } else {
            this.setupMirrorNormalPointer(2048);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    Vector3f[] getNormalRef3f() {
        return this.v3fRefNormals;
    }

    final int getColorStride() {
        return (this.vertexFormat & 8) != 0 ? 4 : 3;
    }

    final int getTexStride() {
        if ((this.vertexFormat & 0x20) != 0) {
            return 2;
        }
        if ((this.vertexFormat & 0x40) != 0) {
            return 3;
        }
        if ((this.vertexFormat & 0x400) != 0) {
            return 4;
        }
        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray121"));
    }

    void setTexCoordRefFloat(int n2, float[] fArray) {
        if (this.texCoordType != 0 && this.texCoordType != 4096) {
            if (fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (fArray != null) {
            int n3 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n2] * n3 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (fArray.length < n3 * (this.initialTexCoordIndex[n2] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n2] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 4096;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n2, 4096);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getTexCoordRefFloat(int n2) {
        return (float[])this.refTexCoords[n2];
    }

    void setTexCoordRefBuffer(int n2, J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            int n3 = floatBufferWrapper.limit();
            assert (floatBufferWrapper.isDirect());
            int n4 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n2] * n4 >= n3) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (n3 < n4 * (this.initialTexCoordIndex[n2] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoordsBuffer[n2] = j3DBuffer;
        this.refTexCoords[n2] = j3DBuffer == null ? null : floatBufferWrapper.getBufferAsObject();
        this.texCoordType = 4096;
        this.validateTexCoordPointerType();
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getTexCoordRefBuffer(int n2) {
        return (J3DBuffer)this.refTexCoordsBuffer[n2];
    }

    void setTexCoordRef2f(int n2, TexCoord2f[] texCoord2fArray) {
        if (this.texCoordType != 0 && this.texCoordType != 8192) {
            if (texCoord2fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoord2fArray != null) {
            if ((this.vertexFormat & 0x20) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n2] >= texCoord2fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord2fArray.length < this.initialTexCoordIndex[n2] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n2] = texCoord2fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 8192;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n2, 8192);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord2f[] getTexCoordRef2f(int n2) {
        if (this.refTexCoords != null && this.refTexCoords[n2] != null && this.refTexCoords[n2] instanceof TexCoord2f[]) {
            return (TexCoord2f[])this.refTexCoords[n2];
        }
        return null;
    }

    void setTexCoordRef3f(int n2, TexCoord3f[] texCoord3fArray) {
        if (this.texCoordType != 0 && this.texCoordType != 16384) {
            if (texCoord3fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoord3fArray != null) {
            if ((this.vertexFormat & 0x40) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n2] >= texCoord3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord3fArray.length < this.initialTexCoordIndex[n2] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.refTexCoords[n2] = texCoord3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 16384;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n2, 16384);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord3f[] getTexCoordRef3f(int n2) {
        if (this.refTexCoords != null && this.refTexCoords[n2] != null && this.refTexCoords[n2] instanceof TexCoord3f[]) {
            return (TexCoord3f[])this.refTexCoords[n2];
        }
        return null;
    }

    void setVertexAttrRefFloat(int n2, float[] fArray) {
        if (fArray != null) {
            int n3 = this.vertexAttrSizes[n2];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (n3 * indexedGeometryArrayRetained.maxVertexAttrIndices[n2] >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (fArray.length < n3 * (this.initialVertexAttrIndex[n2] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.floatRefVertexAttrs[n2] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexAttrType = 32768;
            this.validateVertexAttrPointerType();
        } else {
            this.setupMirrorVertexAttrPointer(n2, 32768);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getVertexAttrRefFloat(int n2) {
        return this.floatRefVertexAttrs[n2];
    }

    void setVertexAttrRefBuffer(int n2, J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            int n3 = floatBufferWrapper.limit();
            assert (floatBufferWrapper.isDirect());
            int n4 = this.vertexAttrSizes[n2];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxVertexAttrIndices[n2] * n4 >= n3) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (n3 < n4 * (this.initialVertexAttrIndex[n2] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.vertexAttrsRefBuffer[n2] = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefVertexAttrs[n2] = null;
            this.nioFloatBufferRefVertexAttrs[n2] = null;
        } else {
            this.floatBufferRefVertexAttrs[n2] = floatBufferWrapper;
            this.nioFloatBufferRefVertexAttrs[n2] = floatBufferWrapper.getBufferAsObject();
        }
        this.vertexAttrType = 32768;
        this.validateVertexAttrPointerType();
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getVertexAttrRefBuffer(int n2) {
        return this.vertexAttrsRefBuffer[n2];
    }

    void setInterleavedVertices(float[] fArray) {
        if (fArray != null) {
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[i2] < fArray.length) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interLeavedVertexData = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(fArray == null);
            this.sendDataChangedMessage(true);
        }
    }

    void setInterleavedVertexBuffer(J3DBuffer j3DBuffer) {
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            assert (floatBufferWrapper.isDirect());
            int n2 = floatBufferWrapper.limit();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[i2] < n2) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (n2 < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interleavedVertexBuffer = j3DBuffer;
        this.interleavedFloatBufferImpl = j3DBuffer == null ? null : floatBufferWrapper;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(j3DBuffer == null);
            this.sendDataChangedMessage(true);
        }
    }

    float[] getInterleavedVertices() {
        return this.interLeavedVertexData;
    }

    J3DBuffer getInterleavedVertexBuffer() {
        return this.interleavedVertexBuffer;
    }

    void setValidVertexCount(int n2) {
        boolean bl = false;
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray110"));
        }
        if (this.initialVertexIndex + n2 > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x100) != 0) {
            if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
                if (this.interleavedFloatBufferImpl.limit() < this.stride * (this.initialVertexIndex + n2)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else if (this.interLeavedVertexData != null) {
                if (this.interLeavedVertexData.length < this.stride * (this.initialVertexIndex + n2)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else {
                bl = true;
            }
        } else if ((this.vertexFormat & 0x80) != 0) {
            int n3;
            if (this.initialCoordIndex + n2 > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
            }
            if (this.initialColorIndex + n2 > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
            }
            if (this.initialNormalIndex + n2 > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    if (this.initialTexCoordIndex[n3] + n2 <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    if (this.initialVertexAttrIndex[n3] + n2 <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
                }
            }
            if ((this.vertexType & 0xF) == 0) {
                bl = true;
            }
            if ((this.vertexFormat & 0x800) != 0) {
                int n4;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (this.initialColorIndex + n2) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (this.initialColorIndex + n2))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (this.initialColorIndex + n2) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (this.initialColorIndex + n2))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n4]).getBufferImpl();
                            if (!((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (this.initialTexCoordIndex[n4] + n2) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (this.initialTexCoordIndex[n4] + n2) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (this.initialTexCoordIndex[n4] + n2)))) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatBufferRefNormals.limit() >= 3 * (this.initialNormalIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                            n4 = this.vertexAttrSizes[n3];
                            if (this.floatBufferRefVertexAttrs[n3].limit() >= n4 * (this.initialVertexAttrIndex[n3] + n2)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords.length >= 3 * (this.initialCoordIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleRefCoords.length >= 3 * (this.initialCoordIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 4: {
                        if (this.p3fRefCoords.length >= this.initialCoordIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 8: {
                        if (this.p3dRefCoords.length >= this.initialCoordIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (this.initialColorIndex + n2) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (this.initialColorIndex + n2))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (this.initialColorIndex + n2) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (this.initialColorIndex + n2))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 64: {
                        if (this.c3fRefColors.length >= this.initialColorIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 128: {
                        if (this.c4fRefColors.length >= this.initialColorIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 256: {
                        if (this.c3bRefColors.length >= this.initialColorIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 512: {
                        if (this.c4bRefColors.length >= this.initialColorIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                            if ((this.vertexFormat & 0x20) != 0) {
                                if (((float[])this.refTexCoords[n3]).length >= 2 * (this.initialTexCoordIndex[n3] + n2)) continue;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x40) == 0) continue;
                            if (((float[])this.refTexCoords[n3]).length < 3 * (this.initialTexCoordIndex[n3] + n2)) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x400) == 0 || ((float[])this.refTexCoords[n3]).length >= 4 * (this.initialTexCoordIndex[n3] + n2)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 8192: {
                        for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                            if (((TexCoord2f[])this.refTexCoords[n3]).length >= this.initialTexCoordIndex[n3] + n2) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 16384: {
                        for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                            if (((TexCoord3f[])this.refTexCoords[n3]).length >= this.initialTexCoordIndex[n3] + n2) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals.length >= 3 * (this.initialNormalIndex + n2)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                    case 2048: {
                        if (this.v3fRefNormals.length >= this.initialNormalIndex + n2) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                            int n5 = this.vertexAttrSizes[n3];
                            if (this.floatRefVertexAttrs[n3].length >= n5 * (this.initialVertexAttrIndex[n3] + n2)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x8F;
        this.validVertexCount = n2;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    int getValidVertexCount() {
        return this.validVertexCount;
    }

    void setInitialVertexIndex(int n2) {
        boolean bl = false;
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
            if (this.interleavedFloatBufferImpl.limit() < this.stride * (n2 + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else if (this.interLeavedVertexData != null) {
            if (this.interLeavedVertexData.length < this.stride * (n2 + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else {
            bl = (this.vertexFormat & 0x100) != 0;
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x8F;
        this.initialVertexIndex = n2;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialVertexIndex() {
        return this.initialVertexIndex;
    }

    void setInitialCoordIndex(int n2) {
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatBufferRefCoords.limit() >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleBufferRefCoords.limit() >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatRefCoords.length >= 3 * (n2 + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleRefCoords.length >= 3 * (n2 + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 4: {
                    if (this.p3fRefCoords.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 8: {
                    if (this.p3dRefCoords.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 1;
        this.initialCoordIndex = n2;
        this.dirtyFlag |= 1;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.processCoordsChanged((this.vertexType & 0xF) == 0);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialCoordIndex() {
        return this.initialCoordIndex;
    }

    void setInitialColorIndex(int n2) {
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (n2 + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (n2 + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        } else {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (n2 + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (n2 + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 64: {
                    if (this.c3fRefColors.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 128: {
                    if (this.c4fRefColors.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 256: {
                    if (this.c3bRefColors.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 512: {
                    if (this.c4bRefColors.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.initialColorIndex = n2;
        this.geomLock.unLock();
    }

    int getInitialColorIndex() {
        return this.initialColorIndex;
    }

    void setInitialNormalIndex(int n2) {
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0xC00) == 1024 && this.floatBufferRefNormals.limit() < 3 * (n2 + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        } else {
            switch (this.vertexType & 0xC00) {
                case 1024: {
                    if (this.floatRefNormals.length >= 3 * (n2 + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
                case 2048: {
                    if (this.v3fRefNormals.length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 2;
        this.initialNormalIndex = n2;
        this.geomLock.unLock();
    }

    int getInitialNormalIndex() {
        return this.initialNormalIndex;
    }

    void setInitialVertexAttrIndex(int n2, int n3) {
        if (n3 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
        }
        int n4 = this.vertexAttrSizes[n2];
        int n5 = n4 * (n3 + this.validVertexCount);
        if ((this.vertexType & 0x8000) == 32768 && ((this.vertexFormat & 0x800) != 0 ? this.floatBufferRefVertexAttrs[n2].limit() < n5 : this.floatRefVertexAttrs[n2].length < n5)) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x80;
        this.initialVertexAttrIndex[n2] = n3;
        this.geomLock.unLock();
    }

    int getInitialVertexAttrIndex(int n2) {
        return this.initialVertexAttrIndex[n2];
    }

    void setInitialTexCoordIndex(int n2, int n3) {
        if (n3 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0x7000) == 4096) {
                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n2]).getBufferImpl();
                if ((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (n3 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (n3 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (n3 + this.validVertexCount))) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        } else {
            switch (this.vertexType & 0x7000) {
                case 4096: {
                    if (!((this.vertexFormat & 0x20) != 0 ? ((float[])this.refTexCoords[n2]).length < 2 * (n3 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? ((float[])this.refTexCoords[n2]).length < 3 * (n3 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && ((float[])this.refTexCoords[n2]).length < 4 * (n3 + this.validVertexCount)))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 8192: {
                    if (((TexCoord2f[])this.refTexCoords[n2]).length >= n3 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 16384: {
                    if (((TexCoord3f[])this.refTexCoords[n2]).length >= n3 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 8;
        this.initialTexCoordIndex[n2] = n3;
        this.geomLock.unLock();
    }

    int getInitialTexCoordIndex(int n2) {
        return this.initialTexCoordIndex[n2];
    }

    int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    int getTexCoordSetMapLength() {
        if (this.texCoordSetMap != null) {
            return this.texCoordSetMap.length;
        }
        return 0;
    }

    void getTexCoordSetMap(int[] nArray) {
        if (this.texCoordSetMap != null) {
            for (int i2 = 0; i2 < this.texCoordSetMap.length; ++i2) {
                nArray[i2] = this.texCoordSetMap[i2];
            }
        }
    }

    void freeDlistId() {
        if (this.dlistId != -1) {
            VirtualUniverse.mc.freeDisplayListId(this.dlistObj);
            this.dlistId = -1;
        }
    }

    void assignDlistId() {
        if (this.dlistId == -1) {
            this.dlistObj = VirtualUniverse.mc.getDisplayListId();
            this.dlistId = this.dlistObj;
        }
    }

    void addDlistUser(RenderBin renderBin, RenderAtomListInfo renderAtomListInfo) {
        HashSet<RenderAtomListInfo> hashSet;
        if (this.dlistUsers == null) {
            this.dlistUsers = new HashMap(2, 1.0f);
        }
        if ((hashSet = (HashSet<RenderAtomListInfo>)this.dlistUsers.get(renderBin)) == null) {
            hashSet = new HashSet<RenderAtomListInfo>();
            this.dlistUsers.put(renderBin, hashSet);
        }
        hashSet.add(renderAtomListInfo);
    }

    void removeDlistUser(RenderBin renderBin, RenderAtomListInfo renderAtomListInfo) {
        if (this.dlistUsers == null) {
            return;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        if (set == null) {
            return;
        }
        set.remove(renderAtomListInfo);
    }

    boolean isDlistUserSetEmpty(RenderBin renderBin) {
        if (this.dlistUsers == null) {
            return true;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        if (set == null) {
            return true;
        }
        return set.isEmpty();
    }

    int numDlistUsers(RenderBin renderBin) {
        if (this.isDlistUserSetEmpty(renderBin)) {
            return 0;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        return set.size();
    }

    void setDlistTimeStamp(int n2, long l2) {
        int n3 = this.getIndex(n2);
        if (n3 >= this.timeStampPerDlist.length) {
            long[] lArray = new long[n3 * 2];
            for (int i2 = 0; i2 < this.timeStampPerDlist.length; ++i2) {
                lArray[i2] = this.timeStampPerDlist[i2];
            }
            this.timeStampPerDlist = lArray;
        }
        this.timeStampPerDlist[n3] = l2;
    }

    long getDlistTimeStamp(int n2) {
        int n3 = this.getIndex(n2);
        if (n3 >= this.timeStampPerDlist.length) {
            this.setDlistTimeStamp(n2, 0L);
        }
        return this.timeStampPerDlist[n3];
    }

    int getIndex(int n2) {
        int n3 = 0;
        while (n2 > 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }

    boolean isWriteStatic() {
        return !this.source.getCapability(1) && !this.source.getCapability(3) && !this.source.getCapability(5) && !this.source.getCapability(7) && !this.source.getCapability(23) && !this.source.getCapability(20) && !this.source.getCapability(19);
    }

    void setCompiled(ArrayList arrayList) {
        int n2 = arrayList.size();
        int n3 = 0;
        this.geoOffset = new int[n2];
        this.compileVcount = new int[n2];
        int n4 = 0;
        int n5 = 0;
        n4 = 0;
        this.isCompiled = true;
        if (n2 > 0) {
            this.source = ((SceneGraphObjectRetained)arrayList.get((int)0)).source;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(i2);
            ((GeometryArray)geometryArrayRetained.source).retained = this;
            this.compileVcount[i2] = geometryArrayRetained.getValidVertexCount();
            n4 += geometryArrayRetained.getValidVertexCount();
            this.geoOffset[i2] = n3;
            n3 += geometryArrayRetained.stride() * this.compileVcount[i2];
            n5 = geometryArrayRetained.getVertexFormat();
        }
        this.createGeometryArrayData(n4, n5);
        this.validVertexCount = n4;
        this.initialVertexIndex = 0;
        this.mergeGeometryArrays(arrayList);
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n2 = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 1;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(i2);
            float[] fArray = geometryArrayRetained.vertexData;
            int n3 = geometryArrayRetained.validVertexCount * this.stride;
            int n4 = geometryArrayRetained.initialVertexIndex * this.stride;
            System.arraycopy(fArray, n4, this.vertexData, n2, n3);
            n2 += n3;
            this.geoBounds.combine(geometryArrayRetained.geoBounds);
        }
        this.centroid.set(this.geoBounds.getCenter());
    }

    boolean isMergeable() {
        if ((this.vertexFormat & 0x80) != 0) {
            return false;
        }
        if (!this.isStatic()) {
            return false;
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.texCoordSetCount > 1 || this.texCoordSetMap != null && this.texCoordSetMap.length > 1)) {
            return false;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            return false;
        }
        return !this.source.getCapability(18);
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if ((this.vertexFormat & 2) != 0) {
            compileState.needNormalsTransform = true;
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.geoBounds != null) {
            this.geoBounds.transform(transformGroupRetained.transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            this.morphUniverseList = new ArrayList(1);
            this.morphUserLists = new ArrayList(1);
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            if (this.morphUniverseList.contains(morphRetained.universe)) {
                int n2 = this.morphUniverseList.indexOf(morphRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n2);
                arrayList2.add(morphRetained);
            } else {
                this.morphUniverseList.add(morphRetained.universe);
                ArrayList<MorphRetained> arrayList3 = new ArrayList<MorphRetained>(5);
                arrayList3.add(morphRetained);
                this.morphUserLists.add(arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            return;
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            int n2 = this.morphUniverseList.indexOf(morphRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n2);
            arrayList2.remove(arrayList2.indexOf(morphRetained));
            if (arrayList2.size() == 0) {
                this.morphUserLists.remove(n2);
                this.morphUniverseList.remove(n2);
            }
        }
    }

    void initMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained) {
            this.mirrorGeometry = (this.vertexFormat & 0x200) == 0 ? ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry() : null;
        }
        this.geomLock.unLock();
    }

    void updateMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained && this.mirrorGeometry != null) {
            this.mirrorGeometry = ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
        }
        this.geomLock.unLock();
    }

    void getVertexData(int n2, Point3d point3d) {
        if ((this.vertexFormat & 0x80) == 0) {
            int n3 = this.stride * n2 + this.coordinateOffset;
            point3d.x = this.vertexData[n3];
            point3d.y = this.vertexData[n3 + 1];
            point3d.z = this.vertexData[n3 + 2];
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n4 = this.stride * n2 + this.coordinateOffset;
                point3d.x = this.interLeavedVertexData[n4];
                point3d.y = this.interLeavedVertexData[n4 + 1];
                point3d.z = this.interLeavedVertexData[n4 + 2];
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        int n5 = n2 * 3;
                        point3d.x = this.floatRefCoords[n5];
                        point3d.y = this.floatRefCoords[n5 + 1];
                        point3d.z = this.floatRefCoords[n5 + 2];
                        break;
                    }
                    case 2: {
                        int n6 = n2 * 3;
                        point3d.x = this.doubleRefCoords[n6];
                        point3d.y = this.doubleRefCoords[n6 + 1];
                        point3d.z = this.doubleRefCoords[n6 + 2];
                        break;
                    }
                    case 4: {
                        point3d.x = this.p3fRefCoords[n2].x;
                        point3d.y = this.p3fRefCoords[n2].y;
                        point3d.z = this.p3fRefCoords[n2].z;
                        break;
                    }
                    case 8: {
                        point3d.x = this.p3dRefCoords[n2].x;
                        point3d.y = this.p3dRefCoords[n2].y;
                        point3d.z = this.p3dRefCoords[n2].z;
                    }
                }
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n7 = this.stride * n2 + this.coordinateOffset;
            point3d.x = this.interleavedFloatBufferImpl.get(n7);
            point3d.y = this.interleavedFloatBufferImpl.get(n7 + 1);
            point3d.z = this.interleavedFloatBufferImpl.get(n7 + 2);
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    int n8 = n2 * 3;
                    point3d.x = this.floatBufferRefCoords.get(n8);
                    point3d.y = this.floatBufferRefCoords.get(n8 + 1);
                    point3d.z = this.floatBufferRefCoords.get(n8 + 2);
                    break;
                }
                case 2: {
                    int n9 = n2 * 3;
                    point3d.x = this.doubleBufferRefCoords.get(n9);
                    point3d.y = this.doubleBufferRefCoords.get(n9 + 1);
                    point3d.z = this.doubleBufferRefCoords.get(n9 + 2);
                }
            }
        }
    }

    void getCrossValue(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        vector3d.x += point3d.y * point3d2.z - point3d.z * point3d2.y;
        vector3d.y += point3d2.x * point3d.z - point3d2.z * point3d.x;
        vector3d.z += point3d.x * point3d2.y - point3d.y * point3d2.x;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = new Transform3D();
        boolean bl = false;
        if (geometryRetained instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
            if (geometryArrayRetained.validVertexCount >= this.validVertexCount) {
                transform3D3.invert(transform3D2);
                transform3D3.mul(transform3D);
                bl = this.intersect(transform3D3, geometryRetained);
            } else {
                transform3D3.invert(transform3D);
                transform3D3.mul(transform3D2);
                bl = geometryArrayRetained.intersect(transform3D3, this);
            }
        } else {
            transform3D3.invert(transform3D);
            transform3D3.mul(transform3D2);
            bl = geometryRetained.intersect(transform3D3, this);
        }
        return bl;
    }

    int getNumCoordCount() {
        int n2 = 0;
        if ((this.vertexFormat & 1) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n2 = this.vertexCount;
                return n2;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xF) {
                        case 1: {
                            n2 = this.floatRefCoords.length / 3;
                            break;
                        }
                        case 2: {
                            n2 = this.doubleRefCoords.length / 3;
                            break;
                        }
                        case 4: {
                            n2 = this.p3fRefCoords.length;
                            break;
                        }
                        case 8: {
                            n2 = this.p3dRefCoords.length;
                        }
                    }
                } else {
                    n2 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        n2 = this.floatBufferRefCoords.limit() / 3;
                        break;
                    }
                    case 2: {
                        n2 = this.doubleBufferRefCoords.limit() / 3;
                    }
                }
            } else {
                n2 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n2;
    }

    int getNumColorCount() {
        int n2 = 0;
        if ((this.vertexFormat & 4) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n2 = this.vertexCount;
                return n2;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x3F0) {
                        case 16: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n2 = this.floatRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n2 = this.floatRefColors.length / 4;
                            break;
                        }
                        case 32: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n2 = this.byteRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n2 = this.byteRefColors.length / 4;
                            break;
                        }
                        case 64: {
                            n2 = this.c3fRefColors.length;
                            break;
                        }
                        case 128: {
                            n2 = this.c4fRefColors.length;
                            break;
                        }
                        case 256: {
                            n2 = this.c3bRefColors.length;
                            break;
                        }
                        case 512: {
                            n2 = this.c4bRefColors.length;
                        }
                    }
                } else {
                    n2 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n2 = this.floatBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n2 = this.floatBufferRefColors.limit() / 4;
                        break;
                    }
                    case 32: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n2 = this.byteBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n2 = this.byteBufferRefColors.limit() / 4;
                    }
                }
            } else {
                n2 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n2;
    }

    int getNumNormalCount() {
        int n2 = 0;
        if ((this.vertexFormat & 2) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n2 = this.vertexCount;
                return n2;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xC00) {
                        case 1024: {
                            n2 = this.floatRefNormals.length / 3;
                            break;
                        }
                        case 2048: {
                            n2 = this.v3fRefNormals.length;
                        }
                    }
                } else {
                    n2 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0xC00) == 1024) {
                    n2 = this.floatBufferRefNormals.limit() / 3;
                }
            } else {
                n2 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n2;
    }

    int getNumTexCoordCount(int n2) {
        int n3 = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n3 = this.vertexCount;
                return n3;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x7000) {
                        case 4096: {
                            if ((this.vertexFormat & 0x20) != 0) {
                                n3 = ((float[])this.refTexCoords[n2]).length / 2;
                                break;
                            }
                            if ((this.vertexFormat & 0x40) != 0) {
                                n3 = ((float[])this.refTexCoords[n2]).length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0x400) == 0) break;
                            n3 = ((float[])this.refTexCoords[n2]).length / 4;
                            break;
                        }
                        case 8192: {
                            n3 = ((TexCoord2f[])this.refTexCoords[n2]).length;
                            break;
                        }
                        case 16384: {
                            n3 = ((TexCoord3f[])this.refTexCoords[n2]).length;
                        }
                    }
                } else {
                    n3 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0x7000) == 4096) {
                    FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n2]).getBufferImpl();
                    if ((this.vertexFormat & 0x20) != 0) {
                        n3 = floatBufferWrapper.limit() / 2;
                    } else if ((this.vertexFormat & 0x40) != 0) {
                        n3 = floatBufferWrapper.limit() / 3;
                    } else if ((this.vertexFormat & 0x400) != 0) {
                        n3 = floatBufferWrapper.limit() / 4;
                    }
                }
            } else {
                n3 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n3;
    }

    void computeMinDistance(Point3d[] point3dArray, Point3d point3d, Vector3d vector3d, double[] dArray, Point3d point3d2) {
        if (point3dArray.length == 1) {
            point3d2.x = point3dArray[0].x;
            point3d2.y = point3dArray[0].y;
            point3d2.z = point3dArray[0].z;
            double d2 = point3d2.x - point3d.x;
            double d3 = point3d2.y - point3d.y;
            double d4 = point3d2.z - point3d.z;
            dArray[0] = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            return;
        }
        if (point3dArray.length == 2) {
            dArray[0] = Math.sqrt(Distance.pointToSegment(point3d, point3dArray[0], point3dArray[1], point3d2, null));
            return;
        }
        double d5 = 0.0;
        if (vector3d == null) {
            int n2;
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            vector3d = new Vector3d();
            int n3 = 0;
            while (n3 < point3dArray.length - 1) {
                vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
                vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
                vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
                if (!(vector3d2.length() > 0.0)) continue;
            }
            for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
                vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
                vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
                vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
                if (vector3d3.length() > 0.0) break;
            }
            if (n2 == point3dArray.length - 1) {
                vector3d = null;
            } else {
                vector3d.cross(vector3d2, vector3d3);
            }
        }
        if (vector3d != null && (d5 = vector3d.length()) == 0.0) {
            vector3d = null;
        }
        if (point3dArray.length == 3) {
            if (vector3d != null) {
                double d6 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
                dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d6) / d5;
                point3d2.x = point3d.x - dArray[0] * vector3d.x / d5;
                point3d2.y = point3d.y - dArray[0] * vector3d.y / d5;
                point3d2.z = point3d.z - dArray[0] * vector3d.z / d5;
                if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d)) {
                    return;
                }
            }
            Point3d point3d3 = new Point3d();
            dArray[0] = Distance.pointToSegment(point3d, point3dArray[0], point3dArray[1], point3d2, null);
            double d7 = Distance.pointToSegment(point3d, point3dArray[1], point3dArray[2], point3d3, null);
            if (d7 < dArray[0]) {
                dArray[0] = d7;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            if ((d7 = Distance.pointToSegment(point3d, point3dArray[2], point3dArray[0], point3d3, null)) < dArray[0]) {
                dArray[0] = d7;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            dArray[0] = Math.sqrt(dArray[0]);
            return;
        }
        if (vector3d != null) {
            double d8 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
            dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d8) / d5;
            point3d2.x = point3d.x - dArray[0] * vector3d.x / d5;
            point3d2.y = point3d.y - dArray[0] * vector3d.y / d5;
            point3d2.z = point3d.z - dArray[0] * vector3d.z / d5;
            if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d) || this.pointInTri(point3d2, point3dArray[1], point3dArray[2], point3dArray[3], vector3d)) {
                return;
            }
        }
        Point3d point3d4 = new Point3d();
        dArray[0] = Distance.pointToSegment(point3d, point3dArray[0], point3dArray[1], point3d2, null);
        double d9 = Distance.pointToSegment(point3d, point3dArray[1], point3dArray[2], point3d4, null);
        if (d9 < dArray[0]) {
            dArray[0] = d9;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d9 = Distance.pointToSegment(point3d, point3dArray[2], point3dArray[3], point3d4, null)) < dArray[0]) {
            dArray[0] = d9;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d9 = Distance.pointToSegment(point3d, point3dArray[3], point3dArray[0], point3d4, null)) < dArray[0]) {
            dArray[0] = d9;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        dArray[0] = Math.sqrt(dArray[0]);
    }

    void handleFrequencyChange(int n2) {
        int n3 = 0;
        if ((this.vertexFormat & 0x80) == 0) {
            if (n2 == 1 || (this.vertexFormat & 4) != 0 && n2 == 3 || (this.vertexFormat & 2) != 0 && n2 == 5 || (this.vertexFormat & 0x460) != 0 && n2 == 7 || (this.vertexFormat & 0x1000) != 0 && n2 == 23 || n2 == 20) {
                n3 = 1;
            }
        } else if (n2 == 19) {
            n3 = 1;
        }
        if (n3 != 0) {
            this.setFrequencyChangeMask(n2, n3);
        }
    }

    int getTexCoordType() {
        return this.texCoordType;
    }

    int getVertexAttrType() {
        return this.vertexAttrType;
    }
}

